/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import proj.zoie.api.DataConsumer;
import proj.zoie.api.ZoieException;
import proj.zoie.impl.indexing.StreamDataProvider;

public class MemoryStreamDataProvider<D>
extends StreamDataProvider<D> {
    private List<DataConsumer.DataEvent<D>> _list = new LinkedList<DataConsumer.DataEvent<D>>();
    private int _count = 0;
    private volatile String _maxVersion = null;
    private static final Logger log = Logger.getLogger(MemoryStreamDataProvider.class);

    public MemoryStreamDataProvider(Comparator<String> versionComparator) {
        super(versionComparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        MemoryStreamDataProvider memoryStreamDataProvider = this;
        synchronized (memoryStreamDataProvider) {
            this._list.clear();
            this.notifyAll();
        }
    }

    public void flush() {
        try {
            String maxVersion = this._maxVersion;
            if (log.isDebugEnabled()) {
                log.debug((Object)("flushing version: " + maxVersion));
            }
            super.syncWithVersion(3600000L, maxVersion);
            if (log.isDebugEnabled()) {
                log.info((Object)("flushing version: " + maxVersion + " done"));
            }
        }
        catch (ZoieException e) {
            log.error((Object)"flush timeout", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvents(List<DataConsumer.DataEvent<D>> list) {
        if (list != null && !list.isEmpty()) {
            Iterator<DataConsumer.DataEvent<D>> iter = list.iterator();
            MemoryStreamDataProvider memoryStreamDataProvider = this;
            synchronized (memoryStreamDataProvider) {
                while (iter.hasNext()) {
                    DataConsumer.DataEvent<D> obj = iter.next();
                    this._maxVersion = this._versionComparator.compare(this._maxVersion, obj.getVersion()) >= 0 ? this._maxVersion : obj.getVersion();
                    ++this._count;
                    this._list.add(obj);
                }
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(DataConsumer.DataEvent<D> event) {
        if (event != null) {
            MemoryStreamDataProvider memoryStreamDataProvider = this;
            synchronized (memoryStreamDataProvider) {
                this._maxVersion = this._versionComparator.compare(this._maxVersion, event.getVersion()) >= 0 ? this._maxVersion : event.getVersion();
                ++this._count;
                this._list.add(event);
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataConsumer.DataEvent<D> next() {
        DataConsumer.DataEvent<D> obj = null;
        MemoryStreamDataProvider memoryStreamDataProvider = this;
        synchronized (memoryStreamDataProvider) {
            if (!this._list.isEmpty()) {
                obj = this._list.remove(0);
                this.notifyAll();
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        MemoryStreamDataProvider memoryStreamDataProvider = this;
        synchronized (memoryStreamDataProvider) {
            return this._count;
        }
    }

    @Override
    public void setStartingOffset(String version) {
        throw new UnsupportedOperationException("not supported");
    }
}

