/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import proj.zoie.api.IndexReaderFactory;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.impl.indexing.AbstractReaderCache;
import proj.zoie.impl.indexing.ReaderCacheFactory;

public class NoopReaderCache<R extends IndexReader>
extends AbstractReaderCache<R> {
    private static final Logger log = Logger.getLogger(NoopReaderCache.class);
    private volatile boolean alreadyShutdown = false;
    private final IndexReaderFactory<ZoieIndexReader<R>> _readerfactory;
    public static ReaderCacheFactory FACTORY = new ReaderCacheFactory(){

        @Override
        public <R extends IndexReader> AbstractReaderCache<R> newInstance(IndexReaderFactory<ZoieIndexReader<R>> readerfactory) {
            return new NoopReaderCache<R>(readerfactory);
        }
    };

    public NoopReaderCache(IndexReaderFactory<ZoieIndexReader<R>> readerfactory) {
        this._readerfactory = readerfactory;
    }

    @Override
    public List<ZoieIndexReader<R>> getIndexReaders() {
        if (!this.alreadyShutdown) {
            try {
                return this._readerfactory.getIndexReaders();
            }
            catch (IOException e) {
                log.error((Object)"getIndexReaders", (Throwable)e);
            }
        }
        return new ArrayList<ZoieIndexReader<R>>(0);
    }

    @Override
    public void returnIndexReaders(List<ZoieIndexReader<R>> readers) {
        this._readerfactory.returnIndexReaders(readers);
    }

    @Override
    public void refreshCache(long timeout) throws ZoieException {
    }

    @Override
    public void shutdown() {
        this.alreadyShutdown = true;
    }

    @Override
    public void start() {
    }

    @Override
    public long getFreshness() {
        return 0L;
    }

    @Override
    public void setFreshness(long freshness) {
    }
}

