/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import proj.zoie.api.IndexReaderFactory;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.impl.indexing.AbstractReaderCache;
import proj.zoie.impl.indexing.DefaultReaderCache;
import proj.zoie.impl.indexing.ReaderCacheFactory;

public class SmartReaderCache<R extends IndexReader>
extends AbstractReaderCache<R> {
    private static final Logger log = Logger.getLogger(DefaultReaderCache.class);
    private final Thread _maintenance;
    private volatile boolean alreadyShutdown = false;
    private volatile List<ZoieIndexReader<R>> cachedreaders = new ArrayList<ZoieIndexReader<R>>(0);
    private volatile long cachedreaderTimestamp = 0L;
    private final Object cachemonitor = new Object();
    private long _freshness = 10000L;
    private final IndexReaderFactory<ZoieIndexReader<R>> _readerfactory;
    private final HashMap<WeakReference<List<ZoieIndexReader<R>>>, List<ZoieIndexReader<R>>> readermap = new HashMap();
    private final ReferenceQueue<List<ZoieIndexReader<R>>> refq = new ReferenceQueue();
    public static ReaderCacheFactory FACTORY = new ReaderCacheFactory(){

        @Override
        public <R extends IndexReader> AbstractReaderCache<R> newInstance(IndexReaderFactory<ZoieIndexReader<R>> readerfactory) {
            return new SmartReaderCache<R>(readerfactory);
        }
    };

    public SmartReaderCache(IndexReaderFactory<ZoieIndexReader<R>> readerfactory) {
        this._readerfactory = readerfactory;
        this._maintenance = this.newMaintenanceThread();
        this._maintenance.setDaemon(true);
    }

    @Override
    public List<ZoieIndexReader<R>> getIndexReaders() {
        return this.cachedreaders;
    }

    @Override
    public void returnIndexReaders(List<ZoieIndexReader<R>> readers) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCache(long timeout) throws ZoieException {
        long begintime = System.currentTimeMillis();
        while (this.cachedreaderTimestamp <= begintime) {
            Object object = this.cachemonitor;
            synchronized (object) {
                this.cachemonitor.notifyAll();
                long elapsed = System.currentTimeMillis() - begintime;
                if (elapsed > timeout) {
                    log.debug((Object)("refreshCached reader timeout in " + elapsed + "ms"));
                    throw new ZoieException("refreshCached reader timeout in " + elapsed + "ms");
                }
                long timetowait = Math.min(timeout - elapsed, 200L);
                try {
                    this.cachemonitor.wait(timetowait);
                }
                catch (InterruptedException e) {
                    log.warn((Object)"refreshCache", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void shutdown() {
        this._freshness = 30000L;
        this.alreadyShutdown = true;
    }

    @Override
    public void start() {
        this._maintenance.start();
    }

    @Override
    public long getFreshness() {
        return this._freshness;
    }

    @Override
    public void setFreshness(long freshness) {
        if (freshness < 0L) {
            log.warn((Object)("freshness has to be at least 0 and cannot be " + freshness));
            freshness = 10000L;
        }
        log.info((Object)("setting freshness to " + freshness + "ms"));
        this._freshness = freshness;
    }

    private Thread newMaintenanceThread() {
        return new Thread("SmartReaderCache-zoie-indexReader-maintenance"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                do {
                    Object w;
                    try {
                        Object object = SmartReaderCache.this.cachemonitor;
                        synchronized (object) {
                            SmartReaderCache.this.cachemonitor.wait(SmartReaderCache.this._freshness);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    List<Object> newreaders = null;
                    if (SmartReaderCache.this.alreadyShutdown) {
                        newreaders = new ArrayList(0);
                    } else {
                        try {
                            newreaders = SmartReaderCache.this._readerfactory.getIndexReaders();
                        }
                        catch (IOException e) {
                            log.info((Object)"SmartReaderCache-zoie-indexReader-maintenance", (Throwable)e);
                            newreaders = new ArrayList();
                        }
                    }
                    SmartReaderCache.this.cachedreaders = new ArrayList(newreaders);
                    if (SmartReaderCache.this.cachedreaders.size() > 0) {
                        w = new WeakReference<List>(SmartReaderCache.this.cachedreaders, SmartReaderCache.this.refq);
                        SmartReaderCache.this.readermap.put(w, newreaders);
                    }
                    SmartReaderCache.this.cachedreaderTimestamp = System.currentTimeMillis();
                    w = SmartReaderCache.this.cachemonitor;
                    synchronized (w) {
                        SmartReaderCache.this.cachemonitor.notifyAll();
                    }
                    Reference wclean = null;
                    while ((wclean = SmartReaderCache.this.refq.poll()) != null) {
                        List readers = (List)SmartReaderCache.this.readermap.remove(wclean);
                        SmartReaderCache.this._readerfactory.returnIndexReaders(readers);
                    }
                } while (!SmartReaderCache.this.alreadyShutdown || SmartReaderCache.this.readermap.size() != 0);
                log.info((Object)"SmartReaderCache-zoie-indexReader-maintenance done.");
            }
        };
    }
}

