/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing;

import java.io.Serializable;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.Version;
import proj.zoie.api.DocIDMapperFactory;
import proj.zoie.api.impl.DefaultDocIDMapperFactory;
import proj.zoie.impl.indexing.DefaultReaderCache;
import proj.zoie.impl.indexing.ReaderCacheFactory;
import proj.zoie.impl.indexing.internal.DefaultRAMIndexFactory;
import proj.zoie.impl.indexing.internal.RAMIndexFactory;

public class ZoieConfig {
    public static final boolean DEFAULT_SETTING_REALTIME = true;
    public static final int DEFAULT_SETTING_BATCHSIZE = 10000;
    public static final int DEFAULT_SETTING_BATCHDELAY = 300000;
    public static final int DEFAULT_MAX_BATCH_SIZE = 10000;
    public static final Comparator<String> DEFAULT_VERSION_COMPARATOR = new DefaultVersionComparator();
    DocIDMapperFactory docidMapperFactory = null;
    Comparator<String> versionComparator = null;
    Analyzer analyzer = null;
    Similarity similarity = null;
    int batchSize = 10000;
    long batchDelay = 300000L;
    boolean rtIndexing = true;
    int maxBatchSize = 10000;
    long _freshness = 10000L;
    ReaderCacheFactory readercachefactory = null;
    RAMIndexFactory<?> ramIndexFactory = null;
    boolean skipBadRecord = false;

    public ZoieConfig() {
        this(DEFAULT_VERSION_COMPARATOR);
    }

    public ZoieConfig(Comparator<String> versionComparator) {
        this.versionComparator = versionComparator;
    }

    public boolean isSkipBadRecord() {
        return this.skipBadRecord;
    }

    public void setSkipBadRecord(boolean skipBadRecord) {
        this.skipBadRecord = skipBadRecord;
    }

    public DocIDMapperFactory getDocidMapperFactory() {
        return this.docidMapperFactory == null ? new DefaultDocIDMapperFactory() : this.docidMapperFactory;
    }

    public void setDocidMapperFactory(DocIDMapperFactory docidMapperFactory) {
        this.docidMapperFactory = docidMapperFactory;
    }

    public Comparator<String> getVersionComparator() {
        return this.versionComparator;
    }

    public void setVersionComparator(Comparator<String> versionComparator) {
        this.versionComparator = versionComparator;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer == null ? new StandardAnalyzer(Version.LUCENE_34) : this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Similarity getSimilarity() {
        return this.similarity == null ? new DefaultSimilarity() : this.similarity;
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public long getBatchDelay() {
        return this.batchDelay;
    }

    public void setBatchDelay(long batchDelay) {
        this.batchDelay = batchDelay;
    }

    public boolean isRtIndexing() {
        return this.rtIndexing;
    }

    public void setRtIndexing(boolean rtIndexing) {
        this.rtIndexing = rtIndexing;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public long getFreshness() {
        return this._freshness;
    }

    public void setFreshness(long freshness) {
        this._freshness = freshness;
    }

    public ReaderCacheFactory getReadercachefactory() {
        if (this.readercachefactory == null) {
            return DefaultReaderCache.FACTORY;
        }
        return this.readercachefactory;
    }

    public void setReadercachefactory(ReaderCacheFactory readercachefactory) {
        this.readercachefactory = readercachefactory;
    }

    public RAMIndexFactory<?> getRamIndexFactory() {
        if (this.ramIndexFactory == null) {
            return new DefaultRAMIndexFactory();
        }
        return this.ramIndexFactory;
    }

    public void setRamIndexFactory(RAMIndexFactory<?> ramIndexFactory) {
        this.ramIndexFactory = ramIndexFactory;
    }

    public static class DefaultVersionComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Pattern _numPattern = Pattern.compile("[0-9]+");

        @Override
        public int compare(String s1, String s2) {
            if (s1 == s2) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            if (_numPattern.matcher(s1).matches() && _numPattern.matcher(s2).matches()) {
                try {
                    return Long.valueOf(s1).compareTo(Long.valueOf(s2));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return s1.compareTo(s2);
        }

        public boolean equals(String s1, String s2) {
            return this.compare(s1, s2) == 0;
        }
    }
}

