/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.Version;
import proj.zoie.api.DefaultDirectoryManager;
import proj.zoie.api.DirectoryManager;
import proj.zoie.api.DocIDMapperFactory;
import proj.zoie.api.Zoie;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieHealth;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.impl.DefaultDocIDMapperFactory;
import proj.zoie.api.impl.util.FileUtil;
import proj.zoie.api.impl.util.SearchUtil;
import proj.zoie.api.indexing.AbstractZoieIndexable;
import proj.zoie.api.indexing.DefaultOptimizeScheduler;
import proj.zoie.api.indexing.IndexReaderDecorator;
import proj.zoie.api.indexing.IndexingEventListener;
import proj.zoie.api.indexing.OptimizeScheduler;
import proj.zoie.api.indexing.ZoieIndexable;
import proj.zoie.api.indexing.ZoieIndexableInterpreter;
import proj.zoie.impl.indexing.AbstractReaderCache;
import proj.zoie.impl.indexing.AsyncDataConsumer;
import proj.zoie.impl.indexing.DefaultIndexReaderDecorator;
import proj.zoie.impl.indexing.DefaultReaderCache;
import proj.zoie.impl.indexing.ReaderCacheFactory;
import proj.zoie.impl.indexing.ZoieConfig;
import proj.zoie.impl.indexing.internal.BatchedIndexDataLoader;
import proj.zoie.impl.indexing.internal.DefaultRAMIndexFactory;
import proj.zoie.impl.indexing.internal.DiskLuceneIndexDataLoader;
import proj.zoie.impl.indexing.internal.RAMIndexFactory;
import proj.zoie.impl.indexing.internal.RealtimeIndexDataLoader;
import proj.zoie.impl.indexing.internal.SearchIndexManager;
import proj.zoie.mbean.ZoieIndexingStatusAdmin;
import proj.zoie.mbean.ZoieIndexingStatusAdminMBean;
import proj.zoie.mbean.ZoieSystemAdminMBean;

public class ZoieSystem<R extends IndexReader, D>
extends AsyncDataConsumer<D>
implements Zoie<R, D> {
    private static final Logger log = Logger.getLogger(ZoieSystem.class);
    private final DirectoryManager _dirMgr;
    private final boolean _realtimeIndexing;
    private final SearchIndexManager<R> _searchIdxMgr;
    private final ZoieIndexableInterpreter<D> _interpreter;
    private final Analyzer _analyzer;
    private final Similarity _similarity;
    private final Queue<IndexingEventListener> _lsnrList;
    private final BatchedIndexDataLoader<R, D> _rtdc;
    private final DiskLuceneIndexDataLoader<R> _diskLoader;
    private volatile boolean alreadyShutdown = false;
    private final ReentrantReadWriteLock _shutdownLock = new ReentrantReadWriteLock();
    private volatile long SLA = 3L;
    private final AbstractReaderCache<R> readercache;
    public static String ZOIEADMIN = "zoie-admin";
    public static String ZOIESTATUS = "zoie-status";

    public ZoieSystem(File idxDir, ZoieIndexableInterpreter<D> interpreter, IndexReaderDecorator<R> indexReaderDecorator, Analyzer analyzer, Similarity similarity, int batchSize, long batchDelay, boolean rtIndexing, Comparator<String> versionComparator, boolean skipBadRecord) {
        this(new DefaultDirectoryManager(idxDir), interpreter, indexReaderDecorator, analyzer, similarity, batchSize, batchDelay, rtIndexing, versionComparator, skipBadRecord);
    }

    public ZoieSystem(DirectoryManager dirMgr, ZoieIndexableInterpreter<D> interpreter, IndexReaderDecorator<R> indexReaderDecorator, ZoieConfig zoieConfig) {
        this(dirMgr, interpreter, indexReaderDecorator, zoieConfig.getDocidMapperFactory(), zoieConfig.getAnalyzer(), zoieConfig.getSimilarity(), zoieConfig.getBatchSize(), zoieConfig.getBatchDelay(), zoieConfig.isRtIndexing(), zoieConfig.getMaxBatchSize(), zoieConfig.getReadercachefactory(), zoieConfig.getRamIndexFactory(), zoieConfig.getVersionComparator(), zoieConfig.isSkipBadRecord());
        this.readercache.setFreshness(zoieConfig.getFreshness());
    }

    public ZoieSystem(File idxDir, ZoieIndexableInterpreter<D> interpreter, IndexReaderDecorator<R> indexReaderDecorator, ZoieConfig zoieConfig) {
        this(new DefaultDirectoryManager(idxDir), interpreter, indexReaderDecorator, zoieConfig.getDocidMapperFactory(), zoieConfig.getAnalyzer(), zoieConfig.getSimilarity(), zoieConfig.getBatchSize(), zoieConfig.getBatchDelay(), zoieConfig.isRtIndexing(), zoieConfig.getMaxBatchSize(), zoieConfig.getReadercachefactory(), zoieConfig.getRamIndexFactory(), zoieConfig.getVersionComparator(), zoieConfig.isSkipBadRecord());
        this.readercache.setFreshness(zoieConfig.getFreshness());
    }

    public ZoieSystem(DirectoryManager dirMgr, ZoieIndexableInterpreter<D> interpreter, IndexReaderDecorator<R> indexReaderDecorator, Analyzer analyzer, Similarity similarity, int batchSize, long batchDelay, boolean rtIndexing, Comparator<String> versionComparator, boolean skipBadRecord) {
        this(dirMgr, interpreter, indexReaderDecorator, (DocIDMapperFactory)new DefaultDocIDMapperFactory(), analyzer, similarity, batchSize, batchDelay, rtIndexing, versionComparator, skipBadRecord);
    }

    public ZoieSystem(DirectoryManager dirMgr, ZoieIndexableInterpreter<D> interpreter, IndexReaderDecorator<R> indexReaderDecorator, DocIDMapperFactory docidMapperFactory, Analyzer analyzer, Similarity similarity, int batchSize, long batchDelay, boolean rtIndexing, Comparator<String> versionComparator, boolean skipBadRecord) {
        this(dirMgr, interpreter, indexReaderDecorator, docidMapperFactory, analyzer, similarity, batchSize, batchDelay, rtIndexing, 10000, versionComparator, skipBadRecord);
    }

    public ZoieSystem(File idxDir, ZoieIndexableInterpreter<D> interpreter, IndexReaderDecorator<R> indexReaderDecorator, DocIDMapperFactory docIdMapperFactory, Analyzer analyzer, Similarity similarity, int batchSize, long batchDelay, boolean rtIndexing, Comparator<String> versionComparator, boolean skipBadRecord) {
        this(new DefaultDirectoryManager(idxDir), interpreter, indexReaderDecorator, docIdMapperFactory, analyzer, similarity, batchSize, batchDelay, rtIndexing, versionComparator, skipBadRecord);
    }

    public ZoieSystem(DirectoryManager dirMgr, ZoieIndexableInterpreter<D> interpreter, IndexReaderDecorator<R> indexReaderDecorator, DocIDMapperFactory docidMapperFactory, Analyzer analyzer, Similarity similarity, int batchSize, long batchDelay, boolean rtIndexing, int maxBatchSize, Comparator<String> versionComparator, boolean skipBadRecord) {
        this(dirMgr, interpreter, indexReaderDecorator, docidMapperFactory, analyzer, similarity, batchSize, batchDelay, rtIndexing, maxBatchSize, DefaultReaderCache.FACTORY, new DefaultRAMIndexFactory(), versionComparator, skipBadRecord);
    }

    public ZoieSystem(DirectoryManager dirMgr, final ZoieIndexableInterpreter<D> interpreter, IndexReaderDecorator<R> indexReaderDecorator, DocIDMapperFactory docidMapperFactory, Analyzer analyzer, Similarity similarity, int batchSize, long batchDelay, boolean rtIndexing, int maxBatchSize, ReaderCacheFactory readercachefactory, RAMIndexFactory<R> ramIndexFactory, Comparator<String> versionComparator, boolean skipBadRecords) {
        super(versionComparator);
        if (dirMgr == null) {
            throw new IllegalArgumentException("null directory manager.");
        }
        this._dirMgr = dirMgr;
        if (interpreter == null) {
            throw new IllegalArgumentException("null interpreter.");
        }
        if (versionComparator == null) {
            throw new IllegalArgumentException("null versionComparator.");
        }
        docidMapperFactory = docidMapperFactory == null ? new DefaultDocIDMapperFactory() : docidMapperFactory;
        this._searchIdxMgr = new SearchIndexManager<R>(this._dirMgr, versionComparator, indexReaderDecorator, docidMapperFactory, ramIndexFactory);
        this._realtimeIndexing = rtIndexing;
        this._interpreter = skipBadRecords ? new ZoieIndexableInterpreter<D>(){

            @Override
            public ZoieIndexable convertAndInterpret(D src) {
                try {
                    ZoieIndexable indexable = interpreter.convertAndInterpret(src);
                    return indexable;
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return new AbstractZoieIndexable(){

                        @Override
                        public long getUID() {
                            return Long.MIN_VALUE;
                        }

                        @Override
                        public boolean isDeleted() {
                            return false;
                        }

                        @Override
                        public boolean isSkip() {
                            return true;
                        }

                        @Override
                        public ZoieIndexable.IndexingReq[] buildIndexingReqs() {
                            return null;
                        }
                    };
                }
            }
        } : interpreter;
        this._analyzer = analyzer == null ? new StandardAnalyzer(Version.LUCENE_34) : analyzer;
        this._similarity = similarity == null ? new DefaultSimilarity() : similarity;
        log.info((Object)("creating Zoie instance --> " + this._dirMgr.toString() + "\t" + this._interpreter.toString() + "\t" + (indexReaderDecorator != null ? indexReaderDecorator.toString() : "null") + "\t" + docidMapperFactory.toString() + "\t" + "Analyzer: " + this._analyzer.toString() + "\tSimilarity: " + this._similarity.toString() + "\tbatchSize (desired max batch size for indexing to RAM): " + batchSize + "\tbatchDelay (max time to wait before flushing to disk): " + batchDelay + "\trealtime mode: " + rtIndexing));
        this._lsnrList = new ConcurrentLinkedQueue<IndexingEventListener>();
        super.setBatchSize(Math.max(1, batchSize));
        this._diskLoader = new DiskLuceneIndexDataLoader<R>(this._analyzer, this._similarity, this._searchIdxMgr, versionComparator, this._lsnrList);
        this._diskLoader.setOptimizeScheduler(new DefaultOptimizeScheduler(this.getAdminMBean()));
        batchSize = Math.max(1, batchSize);
        this._rtdc = this._realtimeIndexing ? new RealtimeIndexDataLoader<R, D>(this._diskLoader, batchSize, Math.max(batchSize, maxBatchSize), batchDelay, this._analyzer, this._similarity, this._searchIdxMgr, this._interpreter, this._lsnrList, versionComparator) : new BatchedIndexDataLoader<R, D>(this._diskLoader, batchSize, Math.max(batchSize, maxBatchSize), batchDelay, this._searchIdxMgr, this._interpreter, this._lsnrList);
        super.setDataConsumer(this._rtdc);
        this.readercache = readercachefactory.newInstance(this._searchIdxMgr);
        log.info((Object)("using readerCache: " + this.readercache));
    }

    public static <D> ZoieSystem<IndexReader, D> buildDefaultInstance(File idxDir, ZoieIndexableInterpreter<D> interpreter, int batchSize, long batchDelay, boolean realtime, Comparator<String> versionComparator) {
        return ZoieSystem.buildDefaultInstance(idxDir, interpreter, (Analyzer)new StandardAnalyzer(Version.LUCENE_34), (Similarity)new DefaultSimilarity(), batchSize, batchDelay, realtime, versionComparator);
    }

    public static <D> ZoieSystem<IndexReader, D> buildDefaultInstance(File idxDir, ZoieIndexableInterpreter<D> interpreter, Analyzer analyzer, Similarity similarity, int batchSize, long batchDelay, boolean realtime, Comparator<String> versionComparator) {
        return new ZoieSystem<IndexReader, D>(idxDir, interpreter, new DefaultIndexReaderDecorator(), analyzer, similarity, batchSize, batchDelay, realtime, versionComparator, false);
    }

    public static <D> ZoieSystem<IndexReader, D> buildDefaultInstance(File idxDir, ZoieIndexableInterpreter<D> interpreter, ZoieConfig zoieConfig) {
        return new ZoieSystem<IndexReader, D>(idxDir, interpreter, new DefaultIndexReaderDecorator(), zoieConfig);
    }

    public void setPurgeFilter(Filter purgeFilter) {
        this._diskLoader.setPurgeFilter(purgeFilter);
    }

    public void addIndexingEventListener(IndexingEventListener lsnr) {
        this._lsnrList.add(lsnr);
    }

    public OptimizeScheduler getOptimizeScheduler() {
        return this._diskLoader.getOptimizeScheduler();
    }

    public void setOptimizeScheduler(OptimizeScheduler scheduler) {
        if (scheduler != null) {
            this._diskLoader.setOptimizeScheduler(scheduler);
        }
    }

    @Override
    public String getVersion() {
        try {
            return this._dirMgr.getVersion();
        }
        catch (IOException e) {
            log.error((Object)e);
            return null;
        }
    }

    public String getCurrentDiskVersion() throws IOException {
        return this._dirMgr.getVersion();
    }

    @Override
    public Analyzer getAnalyzer() {
        return this._analyzer;
    }

    public Similarity getSimilarity() {
        return this._similarity;
    }

    @Override
    public void start() {
        log.info((Object)"starting zoie...");
        this._rtdc.start();
        super.start();
        this.readercache.start();
        log.info((Object)"zoie started...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            this._shutdownLock.writeLock().lock();
            if (this.alreadyShutdown) {
                log.warn((Object)"already shut/shutting down ... ignore new shutdown request");
                return;
            }
            this.alreadyShutdown = true;
            this.readercache.shutdown();
        }
        finally {
            this._shutdownLock.writeLock().unlock();
        }
        OptimizeScheduler scheduler = this._diskLoader.getOptimizeScheduler();
        if (scheduler != null) {
            log.info((Object)"shutting down zoie's OptimizeScheduler ...");
            scheduler.shutdown();
        }
        log.info((Object)"shutting down zoie...");
        try {
            this.flushEvents(Long.MAX_VALUE);
        }
        catch (ZoieException e) {
            log.error((Object)"zoie shutdown encountered ", (Throwable)e);
        }
        this._rtdc.stop();
        super.stop();
        this._searchIdxMgr.close();
        log.info((Object)"zoie shutdown successfully.");
    }

    @Override
    public void stop() {
        this.shutdown();
    }

    public boolean alreadyShutdown() {
        return this.alreadyShutdown;
    }

    public void refreshDiskReader() throws IOException {
        this._searchIdxMgr.refreshDiskReader();
        try {
            this.readercache.refreshCache(20000L);
        }
        catch (ZoieException e) {
            log.warn((Object)"refreshDiskReader refreshCache timeout in 20000ms");
        }
    }

    @Override
    public void flushEvents(long timeout) throws ZoieException {
        super.flushEvents(timeout);
        this._rtdc.flushEvents(timeout);
        this.readercache.refreshCache(timeout);
    }

    public void flushEventsToMemoryIndex(long timeout) throws ZoieException {
        super.flushEvents(timeout);
        this.readercache.refreshCache(timeout);
    }

    public boolean isReadltimeIndexing() {
        return this._realtimeIndexing;
    }

    @Override
    public List<ZoieIndexReader<R>> getIndexReaders() throws IOException {
        long t0 = System.currentTimeMillis();
        List<ZoieIndexReader<R>> readers = this.readercache.getIndexReaders();
        t0 = System.currentTimeMillis() - t0;
        if (t0 > this.SLA) {
            log.warn((Object)("getIndexReaders returned in " + t0 + "ms more than " + this.SLA + "ms using" + this.readercache));
        }
        return readers;
    }

    public int getDiskSegmentCount() throws IOException {
        return this._searchIdxMgr.getDiskSegmentCount();
    }

    public int getRAMASegmentCount() {
        return this._searchIdxMgr.getRAMASegmentCount();
    }

    public int getRAMBSegmentCount() {
        return this._searchIdxMgr.getRAMBSegmentCount();
    }

    @Override
    public void returnIndexReaders(List<ZoieIndexReader<R>> readers) {
        long t0 = System.currentTimeMillis();
        if (readers == null || readers.size() == 0) {
            return;
        }
        this.readercache.returnIndexReaders(readers);
        t0 = System.currentTimeMillis() - t0;
        if (t0 > this.SLA) {
            log.warn((Object)("returnIndexReaders returned in " + t0 + "ms more than " + this.SLA + "ms using " + this.readercache));
        }
    }

    public void purgeIndex() throws IOException {
        try {
            this.flushEvents(20000L);
        }
        catch (ZoieException e) {
            // empty catch block
        }
        this._searchIdxMgr.purgeIndex();
        try {
            this.readercache.refreshCache(20000L);
        }
        catch (ZoieException e) {
            log.error((Object)"refreshCache in purgeIndex", (Throwable)e);
        }
    }

    public String getIndexDir() {
        return this._dirMgr.getPath();
    }

    public int getCurrentMemBatchSize() {
        return this.getCurrentBatchSize();
    }

    public int getCurrentDiskBatchSize() {
        return this._rtdc.getCurrentBatchSize();
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this._rtdc.setMaxBatchSize(maxBatchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinUID() throws IOException {
        long minUID = Long.MAX_VALUE;
        List<ZoieIndexReader<R>> readers = this.getIndexReaders();
        try {
            for (ZoieIndexReader<R> reader : readers) {
                long uid = reader.getMinUID();
                minUID = uid < minUID ? uid : minUID;
            }
            long l = minUID;
            return l;
        }
        finally {
            this.returnIndexReaders(readers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxUID() throws IOException {
        long maxUID = Long.MIN_VALUE;
        List<ZoieIndexReader<R>> readers = this.getIndexReaders();
        try {
            for (ZoieIndexReader<R> reader : readers) {
                long uid = reader.getMaxUID();
                maxUID = uid > maxUID ? uid : maxUID;
            }
            long l = maxUID;
            return l;
        }
        finally {
            this.returnIndexReaders(readers);
        }
    }

    public void exportSnapshot(WritableByteChannel channel) throws IOException {
        this._diskLoader.exportSnapshot(channel);
    }

    public void importSnapshot(ReadableByteChannel channel) throws IOException {
        this._diskLoader.importSnapshot(channel);
    }

    @Override
    public ZoieSystemAdminMBean getAdminMBean() {
        return new MyZoieSystemAdmin();
    }

    @Override
    public StandardMBean getStandardMBean(String name) {
        if (name.equals(ZOIEADMIN)) {
            try {
                return new StandardMBean(this.getAdminMBean(), ZoieSystemAdminMBean.class);
            }
            catch (NotCompliantMBeanException e) {
                log.info((Object)e);
                return null;
            }
        }
        if (name.equals(ZOIESTATUS)) {
            try {
                return new StandardMBean(new ZoieIndexingStatusAdmin(this), ZoieIndexingStatusAdminMBean.class);
            }
            catch (NotCompliantMBeanException e) {
                log.info((Object)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public String[] getStandardMBeanNames() {
        return new String[]{ZOIEADMIN, ZOIESTATUS};
    }

    @Override
    public void syncWithVersion(long timeInMillis, String version) throws ZoieException {
        super.syncWithVersion(timeInMillis, version);
        this.readercache.refreshCache(timeInMillis);
    }

    @Override
    public String getCurrentReaderVersion() {
        return this._searchIdxMgr.getCurrentReaderVersion();
    }

    private class MyZoieSystemAdmin
    implements ZoieSystemAdminMBean {
        private MyZoieSystemAdmin() {
        }

        @Override
        public void refreshDiskReader() throws IOException {
            ZoieSystem.this.refreshDiskReader();
        }

        @Override
        public long getBatchDelay() {
            return ZoieSystem.this._rtdc.getDelay();
        }

        @Override
        public int getBatchSize() {
            return ZoieSystem.this._rtdc.getBatchSize();
        }

        @Override
        public String getCurrentDiskVersion() throws IOException {
            return ZoieSystem.this.getCurrentDiskVersion();
        }

        @Override
        public int getDiskIndexSize() {
            return ZoieSystem.this._searchIdxMgr.getDiskIndexSize();
        }

        @Override
        public long getDiskIndexSizeBytes() {
            return FileUtil.sizeFile(new File(this.getIndexDir()));
        }

        @Override
        public long getDiskFreeSpaceBytes() {
            File index = new File(this.getIndexDir());
            if (!index.exists()) {
                return -1L;
            }
            return index.getUsableSpace();
        }

        @Override
        public String getDiskIndexerStatus() {
            return String.valueOf((Object)ZoieSystem.this._searchIdxMgr.getDiskIndexerStatus());
        }

        @Override
        public Date getLastDiskIndexModifiedTime() {
            return ZoieSystem.this._dirMgr.getLastIndexModifiedTime();
        }

        @Override
        public String getIndexDir() {
            return ZoieSystem.this.getIndexDir();
        }

        @Override
        public Date getLastOptimizationTime() {
            return new Date(ZoieSystem.this._diskLoader.getLastTimeOptimized());
        }

        @Override
        public int getMaxBatchSize() {
            return ZoieSystem.this._rtdc.getMaxBatchSize();
        }

        @Override
        public int getDiskIndexSegmentCount() throws IOException {
            return ZoieSystem.this.getDiskSegmentCount();
        }

        @Override
        public int getRAMASegmentCount() {
            return ZoieSystem.this.getRAMASegmentCount();
        }

        @Override
        public int getRAMBSegmentCount() {
            return ZoieSystem.this.getRAMBSegmentCount();
        }

        @Override
        public boolean isRealtime() {
            return ZoieSystem.this.isReadltimeIndexing();
        }

        @Override
        public int getRamAIndexSize() {
            return ZoieSystem.this._searchIdxMgr.getRamAIndexSize();
        }

        @Override
        public String getRamAVersion() {
            return ZoieSystem.this._searchIdxMgr.getRamAVersion();
        }

        @Override
        public int getRamBIndexSize() {
            return ZoieSystem.this._searchIdxMgr.getRamBIndexSize();
        }

        @Override
        public String getRamBVersion() {
            return ZoieSystem.this._searchIdxMgr.getRamBVersion();
        }

        @Override
        public void optimize(int numSegs) throws IOException {
            ZoieSystem.this._diskLoader.optimize(numSegs);
        }

        @Override
        public void flushToDiskIndex() throws ZoieException {
            log.info((Object)"flushing to disk");
            ZoieSystem.this.flushEvents(Long.MAX_VALUE);
            log.info((Object)"all events flushed to disk");
        }

        @Override
        public void flushToMemoryIndex() throws ZoieException {
            log.info((Object)"flushing to memory");
            ZoieSystem.this.flushEventsToMemoryIndex(Long.MAX_VALUE);
            log.info((Object)"all events flushed to memory");
        }

        @Override
        public void setBatchDelay(long batchDelay) {
            ZoieSystem.this._rtdc.setDelay(batchDelay);
        }

        @Override
        public void setBatchSize(int batchSize) {
            ZoieSystem.this._rtdc.setBatchSize(batchSize);
        }

        @Override
        public void setMaxBatchSize(int maxBatchSize) {
            ZoieSystem.this.setMaxBatchSize(maxBatchSize);
        }

        @Override
        public void purgeIndex() throws IOException {
            ZoieSystem.this.purgeIndex();
        }

        @Override
        public void expungeDeletes() throws IOException {
            ZoieSystem.this._diskLoader.expungeDeletes();
        }

        @Override
        public void setNumLargeSegments(int numLargeSegments) {
            ZoieSystem.this._searchIdxMgr.setNumLargeSegments(numLargeSegments);
        }

        @Override
        public int getNumLargeSegments() {
            return ZoieSystem.this._searchIdxMgr.getNumLargeSegments();
        }

        @Override
        public void setMaxSmallSegments(int maxSmallSegments) {
            ZoieSystem.this._searchIdxMgr.setMaxSmallSegments(maxSmallSegments);
        }

        @Override
        public int getMaxSmallSegments() {
            return ZoieSystem.this._searchIdxMgr.getMaxSmallSegments();
        }

        @Override
        public int getMaxMergeDocs() {
            return ZoieSystem.this._searchIdxMgr.getMaxMergeDocs();
        }

        @Override
        public int getMergeFactor() {
            return ZoieSystem.this._searchIdxMgr.getMergeFactor();
        }

        @Override
        public void setMaxMergeDocs(int maxMergeDocs) {
            ZoieSystem.this._searchIdxMgr.setMaxMergeDocs(maxMergeDocs);
        }

        @Override
        public void setMergeFactor(int mergeFactor) {
            ZoieSystem.this._searchIdxMgr.setMergeFactor(mergeFactor);
        }

        @Override
        public boolean isUseCompoundFile() {
            return ZoieSystem.this._searchIdxMgr.isUseCompoundFile();
        }

        @Override
        public void setUseCompoundFile(boolean useCompoundFile) {
            ZoieSystem.this._searchIdxMgr.setUseCompoundFile(useCompoundFile);
        }

        @Override
        public int getCurrentMemBatchSize() {
            return ZoieSystem.this.getCurrentMemBatchSize();
        }

        @Override
        public int getCurrentDiskBatchSize() {
            return ZoieSystem.this.getCurrentDiskBatchSize();
        }

        @Override
        public long getMinUID() throws IOException {
            return ZoieSystem.this.getMinUID();
        }

        @Override
        public long getMaxUID() throws IOException {
            return ZoieSystem.this.getMaxUID();
        }

        @Override
        public long getHealth() {
            return ZoieHealth.getHealth();
        }

        @Override
        public void resetHealth() {
            ZoieHealth.setOK();
        }

        @Override
        public long getSLA() {
            return ZoieSystem.this.SLA;
        }

        @Override
        public void setSLA(long sla) {
            ZoieSystem.this.SLA = sla;
        }

        @Override
        public long getFreshness() {
            return ZoieSystem.this.readercache.getFreshness();
        }

        @Override
        public void setFreshness(long freshness) {
            ZoieSystem.this.readercache.setFreshness(freshness);
        }

        @Override
        public String search(String field, String query) {
            return SearchUtil.search(ZoieSystem.this, field, query);
        }

        @Override
        public String getDocument(long UID) {
            return SearchUtil.getDocument(ZoieSystem.this, UID);
        }
    }
}

