/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import proj.zoie.api.DocIDMapper;
import proj.zoie.api.ZoieHealth;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.indexing.ZoieIndexable;
import proj.zoie.impl.indexing.internal.SearchIndexManager;

public abstract class BaseSearchIndex<R extends IndexReader> {
    private static final Logger log = Logger.getLogger(BaseSearchIndex.class);
    private int _eventsHandled = 0;
    protected MergeScheduler _mergeScheduler;
    protected IndexWriter _indexWriter = null;
    protected volatile LongOpenHashSet _delDocs = new LongOpenHashSet();
    protected final SearchIndexManager<R> _idxMgr;
    protected boolean _closeWriterAfterUpdate;
    protected final Comparator<String> _versionComparator;

    protected BaseSearchIndex(SearchIndexManager<R> idxMgr, boolean closeWriterAfterUpdate) {
        this._idxMgr = idxMgr;
        this._closeWriterAfterUpdate = closeWriterAfterUpdate;
        this._versionComparator = idxMgr.getVersionComparator();
    }

    abstract String getVersion();

    public abstract int getNumdocs();

    public abstract void setVersion(String var1) throws IOException;

    public void close() {
        this.closeIndexWriter();
    }

    public abstract ZoieIndexReader<R> openIndexReader() throws IOException;

    protected abstract IndexReader openIndexReaderForDelete() throws IOException;

    public abstract void refresh() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndex(LongSet delDocs, List<ZoieIndexable.IndexingReq> insertDocs, Analyzer defaultAnalyzer, Similarity similarity) throws IOException {
        if (delDocs != null && delDocs.size() > 0) {
            this.deleteDocs(delDocs);
        }
        if (insertDocs == null || insertDocs.size() == 0) {
            return;
        }
        IndexWriter idxMod = null;
        try {
            idxMod = this.openIndexWriter(defaultAnalyzer, similarity);
            if (idxMod != null) {
                for (ZoieIndexable.IndexingReq idxPair : insertDocs) {
                    Analyzer analyzer = idxPair.getAnalyzer();
                    Document doc = idxPair.getDocument();
                    if (analyzer == null) {
                        idxMod.addDocument(doc);
                        continue;
                    }
                    idxMod.addDocument(doc, analyzer);
                }
            }
        }
        finally {
            if (idxMod != null) {
                idxMod.commit();
                if (this._closeWriterAfterUpdate) {
                    this.closeIndexWriter();
                }
            }
        }
    }

    public LongSet getDelDocs() {
        return this._delDocs;
    }

    public synchronized void clearDeletes() {
        this._delDocs = new LongOpenHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDeletes(LongSet delDocs) throws IOException {
        if (delDocs != null && delDocs.size() > 0) {
            ZoieIndexReader<R> reader = null;
            BaseSearchIndex baseSearchIndex = this;
            synchronized (baseSearchIndex) {
                reader = this.openIndexReader();
                if (reader == null) {
                    return;
                }
                reader.incZoieRef();
                reader.markDeletes(delDocs, (LongSet)this._delDocs);
            }
            reader.decZoieRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitDeletes() throws IOException {
        ZoieIndexReader<R> reader = null;
        BaseSearchIndex baseSearchIndex = this;
        synchronized (baseSearchIndex) {
            reader = this.openIndexReader();
            if (reader == null) {
                return;
            }
            reader.incZoieRef();
        }
        reader.commitDeletes();
        reader.decZoieRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDocs(LongSet delDocs) throws IOException {
        int[] delArray = null;
        if (delDocs != null && delDocs.size() > 0) {
            ZoieIndexReader<R> reader = null;
            BaseSearchIndex baseSearchIndex = this;
            synchronized (baseSearchIndex) {
                reader = this.openIndexReader();
                if (reader == null) {
                    return;
                }
                reader.incZoieRef();
            }
            IntArrayList delList = new IntArrayList(delDocs.size());
            DocIDMapper<?> idMapper = reader.getDocIDMaper();
            LongIterator iter = delDocs.iterator();
            while (iter.hasNext()) {
                int docid;
                long l = iter.nextLong();
                if (Long.MIN_VALUE == l || (docid = idMapper.getDocID(l)) == -1) continue;
                delList.add(docid);
            }
            delArray = delList.toIntArray();
            reader.decZoieRef();
        }
        if (delArray != null && delArray.length > 0) {
            this.closeIndexWriter();
            IndexReader readerForDelete = null;
            try {
                readerForDelete = this.openIndexReaderForDelete();
                if (readerForDelete != null) {
                    for (void var7_12 : delArray) {
                        readerForDelete.deleteDocument((int)var7_12);
                    }
                }
            }
            finally {
                if (readerForDelete != null) {
                    try {
                        readerForDelete.close();
                    }
                    catch (IOException ioe) {
                        ZoieHealth.setFatal();
                        log.error((Object)ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromIndex(BaseSearchIndex<R> index) throws IOException {
        ZoieIndexReader<R> reader;
        if (this._delDocs != null && this._delDocs.size() > 0) {
            LongOpenHashSet delDocs = this._delDocs;
            this.clearDeletes();
            this.deleteDocs((LongSet)delDocs);
        }
        if ((reader = index.openIndexReader()) == null) {
            return;
        }
        Directory dir = reader.directory();
        IndexWriter writer = null;
        try {
            writer = this.openIndexWriter(null, null);
            writer.addIndexes(new Directory[]{dir});
            writer.maybeMerge();
        }
        finally {
            this.closeIndexWriter();
        }
    }

    public abstract IndexWriter openIndexWriter(Analyzer var1, Similarity var2) throws IOException;

    public void closeIndexWriter() {
        if (this._indexWriter != null) {
            try {
                this._indexWriter.close();
            }
            catch (Exception e) {
                ZoieHealth.setFatal();
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            this._indexWriter = null;
        }
    }

    public void incrementEventCount(int eventCount) {
        this._eventsHandled += eventCount;
    }

    public int getEventsHandled() {
        return this._eventsHandled;
    }
}

