/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import proj.zoie.api.DataConsumer;
import proj.zoie.api.LifeCycleCotrolledDataConsumer;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieHealth;
import proj.zoie.api.indexing.AbstractZoieIndexable;
import proj.zoie.api.indexing.IndexingEventListener;
import proj.zoie.api.indexing.ZoieIndexable;
import proj.zoie.api.indexing.ZoieIndexableInterpreter;
import proj.zoie.impl.indexing.IndexUpdatedEvent;
import proj.zoie.impl.indexing.IndexingThread;
import proj.zoie.impl.indexing.internal.SearchIndexManager;

public class BatchedIndexDataLoader<R extends IndexReader, D>
implements LifeCycleCotrolledDataConsumer<D> {
    protected int _batchSize;
    protected long _delay;
    protected final DataConsumer<ZoieIndexable> _dataLoader;
    protected List<DataConsumer.DataEvent<ZoieIndexable>> _batchList;
    protected final LoaderThread _loadMgrThread;
    protected long _lastFlushTime;
    protected int _eventCount;
    protected int _maxBatchSize;
    protected volatile boolean _stop;
    protected boolean _flush;
    protected final SearchIndexManager<R> _idxMgr;
    protected final ZoieIndexableInterpreter<D> _interpreter;
    private final Queue<IndexingEventListener> _lsnrList;
    private static Logger log = Logger.getLogger(BatchedIndexDataLoader.class);

    public BatchedIndexDataLoader(DataConsumer<ZoieIndexable> dataLoader, int batchSize, int maxBatchSize, long delay, SearchIndexManager<R> idxMgr, ZoieIndexableInterpreter<D> interpreter, Queue<IndexingEventListener> lsnrList) {
        this._maxBatchSize = Math.max(maxBatchSize, batchSize);
        this._batchSize = Math.min(batchSize, this._maxBatchSize);
        this._delay = delay;
        this._dataLoader = dataLoader;
        this._batchList = new LinkedList<DataConsumer.DataEvent<ZoieIndexable>>();
        this._lastFlushTime = 0L;
        this._eventCount = 0;
        this._loadMgrThread = new LoaderThread();
        this._loadMgrThread.setName("disk indexer data loader");
        this._stop = false;
        this._flush = false;
        this._idxMgr = idxMgr;
        this._interpreter = interpreter;
        this._lsnrList = lsnrList;
        log.info((Object)("constructor: _maxBatchSize: " + this._maxBatchSize + " _batchSize: " + this._batchSize + " _delay: " + this._delay));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireIndexingEvent(IndexingEventListener.IndexingEvent evt) {
        if (this._lsnrList != null && this._lsnrList.size() > 0) {
            Queue<IndexingEventListener> queue = this._lsnrList;
            synchronized (queue) {
                for (IndexingEventListener lsnr : this._lsnrList) {
                    try {
                        lsnr.handleIndexingEvent(evt);
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireNewVersionEvent(String newVersion) {
        if (this._lsnrList != null && this._lsnrList.size() > 0) {
            Queue<IndexingEventListener> queue = this._lsnrList;
            synchronized (queue) {
                for (IndexingEventListener lsnr : this._lsnrList) {
                    try {
                        lsnr.handleUpdatedDiskVersion(newVersion);
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public synchronized int getMaxBatchSize() {
        return this._maxBatchSize;
    }

    public synchronized void setMaxBatchSize(int maxBatchSize) {
        this._maxBatchSize = Math.max(maxBatchSize, this._batchSize);
        this._batchSize = Math.min(this._batchSize, this._maxBatchSize);
        log.info((Object)("setMaxBatchSize: " + this._maxBatchSize));
    }

    public synchronized int getBatchSize() {
        return this._batchSize;
    }

    public synchronized void setBatchSize(int batchSize) {
        this._batchSize = Math.min(Math.max(1, batchSize), this._maxBatchSize);
        log.info((Object)("setBatchSize: " + this._batchSize));
    }

    public synchronized long getDelay() {
        return this._delay;
    }

    public synchronized void setDelay(long delay) {
        this._delay = delay;
        log.info((Object)("setDelay: " + this._delay));
    }

    public synchronized int getEventCount() {
        return this._eventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(Collection<DataConsumer.DataEvent<D>> events) throws ZoieException {
        if (events != null) {
            ArrayList<DataConsumer.DataEvent<ZoieIndexable>> indexableList = new ArrayList<DataConsumer.DataEvent<ZoieIndexable>>(events.size());
            Iterator<DataConsumer.DataEvent<D>> iter = events.iterator();
            while (iter.hasNext()) {
                try {
                    DataConsumer.DataEvent<D> event = iter.next();
                    ZoieIndexable indexable = this._interpreter.convertAndInterpret(event.getData());
                    DataConsumer.DataEvent<ZoieIndexable> newEvent = new DataConsumer.DataEvent<ZoieIndexable>(indexable, event.getVersion(), event.isDelete());
                    indexableList.add(newEvent);
                }
                catch (Exception e) {
                    ZoieHealth.setFatal();
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            BatchedIndexDataLoader batchedIndexDataLoader = this;
            synchronized (batchedIndexDataLoader) {
                while (this._batchList.size() > this._maxBatchSize) {
                    if (this._loadMgrThread == null || !this._loadMgrThread.isAlive()) {
                        throw new ZoieException("fatal: indexing thread loader manager has stopped");
                    }
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException e) {}
                }
                this._eventCount += indexableList.size();
                this._batchList.addAll(indexableList);
                this.notifyAll();
            }
        }
    }

    public synchronized int getCurrentBatchSize() {
        return this._batchList != null ? this._batchList.size() : 0;
    }

    protected List<DataConsumer.DataEvent<ZoieIndexable>> getBatchList() {
        List<DataConsumer.DataEvent<ZoieIndexable>> tmpList = this._batchList;
        this._batchList = new LinkedList<DataConsumer.DataEvent<ZoieIndexable>>();
        return tmpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushEvents(long timeOut) throws ZoieException {
        BatchedIndexDataLoader batchedIndexDataLoader = this;
        synchronized (batchedIndexDataLoader) {
            while (this._eventCount > 0) {
                this._flush = true;
                this.notifyAll();
                long now1 = System.currentTimeMillis();
                if (timeOut <= 0L) {
                    log.error((Object)"sync timed out");
                    throw new ZoieException("timed out");
                }
                try {
                    long waittime = Math.min(200L, timeOut);
                    this.wait(waittime);
                }
                catch (InterruptedException e) {
                    throw new ZoieException(e.getMessage());
                }
                long now2 = System.currentTimeMillis();
                timeOut -= now2 - now1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBatch() {
        String currentVersion;
        List tmpList = null;
        long now = System.currentTimeMillis();
        long duration = now - this._lastFlushTime;
        try {
            currentVersion = this._idxMgr.getCurrentDiskVersion();
        }
        catch (IOException ioe) {
            currentVersion = null;
        }
        BatchedIndexDataLoader ioe = this;
        synchronized (ioe) {
            while (this._batchList.size() < this._batchSize && !this._stop && !this._flush && duration < this._delay) {
                try {
                    this.wait(this._delay - duration);
                }
                catch (InterruptedException e) {
                    log.warn((Object)e.getMessage());
                }
                now = System.currentTimeMillis();
                duration = now - this._lastFlushTime;
            }
            this._flush = false;
            this._lastFlushTime = now;
            if (this._batchList.size() > 0) {
                this._idxMgr.setDiskIndexerStatus(SearchIndexManager.Status.Working);
                tmpList = this.getBatchList();
            }
        }
        if (tmpList != null) {
            long t1 = System.currentTimeMillis();
            int eventCount = tmpList.size();
            Comparator<String> versioComparator = this._idxMgr.getVersionComparator();
            for (DataConsumer.DataEvent<ZoieIndexable> dataEvent : tmpList) {
                String newVersion = dataEvent.getVersion();
                if (currentVersion == null) {
                    currentVersion = newVersion;
                    continue;
                }
                if (versioComparator.compare(currentVersion, newVersion) >= 0) continue;
                currentVersion = newVersion;
            }
            try {
                this._dataLoader.consume(tmpList);
            }
            catch (ZoieException e) {
                ZoieHealth.setFatal();
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                long t2 = System.currentTimeMillis();
                BatchedIndexDataLoader batchedIndexDataLoader = this;
                synchronized (batchedIndexDataLoader) {
                    this._eventCount -= eventCount;
                    this.notifyAll();
                    log.info((Object)(this + " flushed batch of " + eventCount + " events to disk indexer, took: " + (t2 - t1) + " current event count: " + this._eventCount));
                    IndexUpdatedEvent evt = new IndexUpdatedEvent(eventCount, t1, t2, this._eventCount);
                    this.fireIndexingEvent(evt);
                    try {
                        String oldVersion = this._idxMgr.getCurrentDiskVersion();
                        if (currentVersion != null && !currentVersion.equals(oldVersion)) {
                            this.fireNewVersionEvent(currentVersion);
                        }
                    }
                    catch (IOException ioe2) {
                        log.error((Object)ioe2.getMessage(), (Throwable)ioe2);
                    }
                }
            }
        } else {
            log.debug((Object)"batch size is 0");
        }
    }

    @Override
    public void start() {
        this._loadMgrThread.setName(String.valueOf(this));
        this._loadMgrThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        BatchedIndexDataLoader batchedIndexDataLoader = this;
        synchronized (batchedIndexDataLoader) {
            this._stop = true;
            this.notifyAll();
        }
        try {
            this._loadMgrThread.join();
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<String> getVersionComparator() {
        throw new UnsupportedOperationException();
    }

    protected static class ZoieIndexableDecorator
    extends AbstractZoieIndexable {
        private final ZoieIndexable _inner;

        private ZoieIndexableDecorator(ZoieIndexable inner) {
            this._inner = inner;
        }

        public static ZoieIndexableDecorator decorate(ZoieIndexable inner) {
            return inner == null ? null : new ZoieIndexableDecorator(inner);
        }

        @Override
        public ZoieIndexable.IndexingReq[] buildIndexingReqs() {
            return this._inner.buildIndexingReqs();
        }

        @Override
        public long getUID() {
            return this._inner.getUID();
        }

        @Override
        public boolean isDeleted() {
            return this._inner.isDeleted();
        }

        @Override
        public boolean isSkip() {
            return this._inner.isSkip();
        }
    }

    protected class LoaderThread
    extends IndexingThread {
        LoaderThread() {
            super("disk indexer data loader");
        }

        @Override
        public void run() {
            while (!BatchedIndexDataLoader.this._stop) {
                BatchedIndexDataLoader.this.processBatch();
            }
        }
    }
}

