/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import proj.zoie.api.indexing.IndexReaderDecorator;
import proj.zoie.impl.indexing.internal.DefaultRAMIndexFactory;
import proj.zoie.impl.indexing.internal.RAMIndexFactory;
import proj.zoie.impl.indexing.internal.RAMSearchIndex;
import proj.zoie.impl.indexing.internal.SearchIndexManager;

public class DefaultRAMDiskIndexFactory<R extends IndexReader>
extends RAMIndexFactory<R> {
    private static final Logger log = Logger.getLogger(DefaultRAMIndexFactory.class);
    private static int fold = 10000;

    @Override
    public synchronized RAMSearchIndex<R> newInstance(String version, IndexReaderDecorator<R> decorator, SearchIndexManager<R> idxMgr) {
        try {
            File backingdir = new File("/tmp/ram" + fold);
            SimpleFSDirectory ramIdxDir = new SimpleFSDirectory(backingdir);
            ++fold;
            return new RAMSearchIndex<R>(version, decorator, idxMgr, (Directory)ramIdxDir, backingdir);
        }
        catch (IOException e) {
            log.error((Object)e);
            e.printStackTrace();
            return null;
        }
    }
}

