/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.log4j.Logger;
import proj.zoie.api.DataConsumer;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieHealth;
import proj.zoie.api.indexing.ZoieIndexable;
import proj.zoie.api.indexing.ZoieIndexableInterpreter;

public class DelegateIndexDataConsumer<D>
implements DataConsumer<D> {
    private static final Logger log = Logger.getLogger(DelegateIndexDataConsumer.class);
    private final DataConsumer<ZoieIndexable> _diskConsumer;
    private final DataConsumer<ZoieIndexable> _ramConsumer;
    private final ZoieIndexableInterpreter<D> _interpreter;

    public DelegateIndexDataConsumer(DataConsumer<ZoieIndexable> diskConsumer, DataConsumer<ZoieIndexable> ramConsumer, ZoieIndexableInterpreter<D> interpreter) {
        this._diskConsumer = diskConsumer;
        this._ramConsumer = ramConsumer;
        this._interpreter = interpreter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(Collection<DataConsumer.DataEvent<D>> data) throws ZoieException {
        if (data != null) {
            ArrayList indexableList = new ArrayList(data.size());
            Iterator<DataConsumer.DataEvent<D>> iter = data.iterator();
            while (iter.hasNext()) {
                try {
                    DataConsumer.DataEvent<D> event = iter.next();
                    ZoieIndexable indexable = this._interpreter.convertAndInterpret(event.getData());
                    DataConsumer.DataEvent<ZoieIndexable> newEvent = new DataConsumer.DataEvent<ZoieIndexable>(indexable, event.getVersion(), event.isDelete());
                    indexableList.add(newEvent);
                }
                catch (Exception e) {
                    ZoieHealth.setFatal();
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (this._diskConsumer != null) {
                DataConsumer<ZoieIndexable> dataConsumer = this._diskConsumer;
                synchronized (dataConsumer) {
                    if (this._ramConsumer != null) {
                        ArrayList ramList = new ArrayList(indexableList);
                        this._ramConsumer.consume(ramList);
                    }
                    this._diskConsumer.consume(indexableList);
                }
            } else if (this._ramConsumer != null) {
                this._ramConsumer.consume(indexableList);
            }
        }
    }

    @Override
    public String getVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<String> getVersionComparator() {
        throw new UnsupportedOperationException();
    }
}

