/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import proj.zoie.api.DirectoryManager;
import proj.zoie.api.impl.util.ChannelUtil;
import proj.zoie.impl.indexing.internal.IndexSignature;
import proj.zoie.impl.indexing.internal.ZoieIndexDeletionPolicy;

public class DiskIndexSnapshot {
    private DirectoryManager _dirMgr;
    private IndexSignature _sig;
    private ZoieIndexDeletionPolicy.Snapshot _snapshot;

    public DiskIndexSnapshot(DirectoryManager dirMgr, IndexSignature sig, ZoieIndexDeletionPolicy.Snapshot snapshot) {
        this._dirMgr = dirMgr;
        this._sig = sig;
        this._snapshot = snapshot;
    }

    public void close() {
        this._snapshot.close();
    }

    public DirectoryManager getDirecotryManager() {
        return this._dirMgr;
    }

    public long writeTo(WritableByteChannel channel) throws IOException {
        long amount = 0L;
        amount += ChannelUtil.writeInt(channel, 1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this._sig.save(baos);
        byte[] sigBytes = baos.toByteArray();
        amount += ChannelUtil.writeLong(channel, sigBytes.length);
        amount += (long)channel.write(ByteBuffer.wrap(sigBytes));
        Collection<String> fileNames = this._snapshot.getFileNames();
        amount += ChannelUtil.writeInt(channel, fileNames.size());
        for (String fileName : fileNames) {
            amount += ChannelUtil.writeString(channel, fileName);
            amount += this._dirMgr.transferFromFileToChannel(fileName, channel);
        }
        return amount;
    }

    public static void readSnapshot(ReadableByteChannel channel, DirectoryManager dirMgr) throws IOException {
        int formatVersion = ChannelUtil.readInt(channel);
        if (formatVersion != 1) {
            throw new IOException("snapshot format version mismatch [" + formatVersion + "]");
        }
        if (!dirMgr.transferFromChannelToFile(channel, "index.directory")) {
            throw new IOException("bad snapshot file");
        }
        int numFiles = ChannelUtil.readInt(channel);
        if (numFiles < 0) {
            throw new IOException("bad snapshot file");
        }
        while (numFiles-- > 0) {
            String fileName = ChannelUtil.readString(channel);
            if (fileName == null) {
                throw new IOException("bad snapshot file");
            }
            if (dirMgr.transferFromChannelToFile(channel, fileName)) continue;
            throw new IOException("bad snapshot file");
        }
    }
}

