/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Comparator;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Similarity;
import proj.zoie.api.DataConsumer;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieHealth;
import proj.zoie.api.indexing.IndexingEventListener;
import proj.zoie.api.indexing.OptimizeScheduler;
import proj.zoie.api.indexing.ZoieIndexable;
import proj.zoie.impl.indexing.internal.BaseSearchIndex;
import proj.zoie.impl.indexing.internal.DiskIndexSnapshot;
import proj.zoie.impl.indexing.internal.DiskSearchIndex;
import proj.zoie.impl.indexing.internal.LuceneIndexDataLoader;
import proj.zoie.impl.indexing.internal.RAMSearchIndex;
import proj.zoie.impl.indexing.internal.SearchIndexManager;

public class DiskLuceneIndexDataLoader<R extends IndexReader>
extends LuceneIndexDataLoader<R> {
    private long _lastTimeOptimized = System.currentTimeMillis();
    private static final Logger log = Logger.getLogger(DiskLuceneIndexDataLoader.class);
    private Object _optimizeMonitor = new Object();
    private volatile OptimizeScheduler _optScheduler;

    public DiskLuceneIndexDataLoader(Analyzer analyzer, Similarity similarity, SearchIndexManager<R> idxMgr, Comparator<String> comparator, Queue<IndexingEventListener> lsnrList) {
        super(analyzer, similarity, idxMgr, comparator, lsnrList);
    }

    public void setOptimizeScheduler(OptimizeScheduler scheduler) {
        this._optScheduler = scheduler;
    }

    public OptimizeScheduler getOptimizeScheduler() {
        return this._optScheduler;
    }

    @Override
    protected BaseSearchIndex<R> getSearchIndex() {
        return this._idxMgr.getDiskIndex();
    }

    @Override
    protected void propagateDeletes(LongSet delDocs) throws IOException {
    }

    @Override
    protected void commitPropagatedDeletes() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(Collection<DataConsumer.DataEvent<ZoieIndexable>> events) throws ZoieException {
        Object object = this._optimizeMonitor;
        synchronized (object) {
            block15: {
                try {
                    this._idxMgr.setDiskIndexerStatus(SearchIndexManager.Status.Working);
                    OptimizeScheduler.OptimizeType optType = this._optScheduler.getScheduledOptimizeType();
                    this._idxMgr.setPartialExpunge(optType == OptimizeScheduler.OptimizeType.PARTIAL);
                    try {
                        super.consume(events);
                    }
                    finally {
                        this._optScheduler.finished();
                        this._idxMgr.setPartialExpunge(false);
                    }
                    if (optType != OptimizeScheduler.OptimizeType.FULL) break block15;
                    try {
                        this.expungeDeletes();
                    }
                    catch (IOException ioe) {
                        ZoieHealth.setFatal();
                        throw new ZoieException(ioe.getMessage(), ioe);
                    }
                    finally {
                        this._optScheduler.finished();
                    }
                }
                finally {
                    this._idxMgr.setDiskIndexerStatus(SearchIndexManager.Status.Sleep);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromIndex(RAMSearchIndex<R> ramIndex) throws ZoieException {
        Object object = this._optimizeMonitor;
        synchronized (object) {
            block15: {
                try {
                    this._idxMgr.setDiskIndexerStatus(SearchIndexManager.Status.Working);
                    OptimizeScheduler.OptimizeType optType = this._optScheduler.getScheduledOptimizeType();
                    this._idxMgr.setPartialExpunge(optType == OptimizeScheduler.OptimizeType.PARTIAL);
                    try {
                        super.loadFromIndex(ramIndex);
                    }
                    finally {
                        this._optScheduler.finished();
                        this._idxMgr.setPartialExpunge(false);
                    }
                    if (optType != OptimizeScheduler.OptimizeType.FULL) break block15;
                    try {
                        this.expungeDeletes();
                    }
                    catch (IOException ioe) {
                        ZoieHealth.setFatal();
                        throw new ZoieException(ioe.getMessage(), ioe);
                    }
                    finally {
                        this._optScheduler.finished();
                    }
                }
                finally {
                    this._idxMgr.setDiskIndexerStatus(SearchIndexManager.Status.Sleep);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expungeDeletes() throws IOException {
        log.info((Object)"expunging deletes...");
        Object object = this._optimizeMonitor;
        synchronized (object) {
            BaseSearchIndex<R> idx = this.getSearchIndex();
            IndexWriter writer = null;
            try {
                writer = idx.openIndexWriter(this._analyzer, this._similarity);
                writer.expungeDeletes(true);
            }
            finally {
                if (writer != null) {
                    idx.closeIndexWriter();
                }
            }
            this._idxMgr.refreshDiskReader();
        }
        log.info((Object)"deletes expunged");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize(int numSegs) throws IOException {
        long t0 = System.currentTimeMillis();
        if (numSegs <= 1) {
            numSegs = 1;
        }
        log.info((Object)("optmizing, numSegs: " + numSegs + " ..."));
        Object object = this._optimizeMonitor;
        synchronized (object) {
            BaseSearchIndex<R> idx = this.getSearchIndex();
            IndexWriter writer = null;
            try {
                writer = idx.openIndexWriter(this._analyzer, this._similarity);
                writer.optimize(numSegs);
            }
            finally {
                if (writer != null) {
                    idx.closeIndexWriter();
                }
            }
            this._idxMgr.refreshDiskReader();
        }
        log.info((Object)("index optimized in " + (System.currentTimeMillis() - t0) + "ms"));
    }

    public long getLastTimeOptimized() {
        return this._lastTimeOptimized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long exportSnapshot(WritableByteChannel channel) throws IOException {
        DiskSearchIndex idx = (DiskSearchIndex)this.getSearchIndex();
        if (idx != null) {
            DiskIndexSnapshot snapshot = null;
            try {
                Object object = this._optimizeMonitor;
                synchronized (object) {
                    snapshot = idx.getSnapshot();
                }
                long l = snapshot != null ? snapshot.writeTo(channel) : 0L;
                return l;
            }
            finally {
                if (snapshot != null) {
                    snapshot.close();
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importSnapshot(ReadableByteChannel channel) throws IOException {
        DiskSearchIndex idx = (DiskSearchIndex)this.getSearchIndex();
        if (idx != null) {
            Object object = this._optimizeMonitor;
            synchronized (object) {
                this._idxMgr.purgeIndex();
                idx.importSnapshot(channel);
                this._idxMgr.refreshDiskReader();
            }
        }
    }
}

