/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import proj.zoie.api.DirectoryManager;
import proj.zoie.api.ZoieHealth;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.impl.ZoieMergePolicy;
import proj.zoie.api.impl.util.IndexUtil;
import proj.zoie.api.indexing.IndexReaderDecorator;
import proj.zoie.impl.indexing.internal.BaseSearchIndex;
import proj.zoie.impl.indexing.internal.DiskIndexSnapshot;
import proj.zoie.impl.indexing.internal.IndexReaderDispenser;
import proj.zoie.impl.indexing.internal.IndexSignature;
import proj.zoie.impl.indexing.internal.SearchIndexManager;
import proj.zoie.impl.indexing.internal.ZoieIndexDeletionPolicy;

public class DiskSearchIndex<R extends IndexReader>
extends BaseSearchIndex<R> {
    private final DirectoryManager _dirMgr;
    private final IndexReaderDispenser<R> _dispenser;
    final ZoieMergePolicy.MergePolicyParams _mergePolicyParams;
    private ZoieIndexDeletionPolicy _deletionPolicy;
    public static final Logger log = Logger.getLogger(DiskSearchIndex.class);
    private final Object readerOpenLock = new Object();

    public DiskSearchIndex(DirectoryManager dirMgr, IndexReaderDecorator<R> decorator, SearchIndexManager<R> idxMgr) {
        super(idxMgr, true);
        this._dirMgr = dirMgr;
        this._mergePolicyParams = new ZoieMergePolicy.MergePolicyParams();
        this._dispenser = new IndexReaderDispenser<R>(this._dirMgr, decorator, this);
        this._mergeScheduler = new SerialMergeScheduler();
        this._deletionPolicy = new ZoieIndexDeletionPolicy();
    }

    @Override
    public String getVersion() {
        return this._dispenser.getCurrentVersion();
    }

    public ZoieMergePolicy.MergePolicyParams getMergePolicyParams() {
        return this._mergePolicyParams;
    }

    @Override
    public int getNumdocs() {
        ZoieIndexReader<R> reader = this._dispenser.getIndexReader();
        if (reader != null) {
            return reader.numDocs();
        }
        return 0;
    }

    public int getSegmentCount() throws IOException {
        if (this._dirMgr == null || !this._dirMgr.exists()) {
            return 0;
        }
        Directory dir = null;
        try {
            dir = this._dirMgr.getDirectory();
        }
        catch (Exception e) {
            return 0;
        }
        if (dir == null) {
            return 0;
        }
        return IndexUtil.getNumSegments(dir);
    }

    public String getSegmentInfo() {
        if (this._dirMgr == null || !this._dirMgr.exists()) {
            return "";
        }
        Directory dir = null;
        try {
            dir = this._dirMgr.getDirectory();
        }
        catch (Exception e) {
            return "";
        }
        if (dir == null) {
            return "";
        }
        return IndexUtil.getSegmentsInfo(dir);
    }

    @Override
    public void close() {
        super.close();
        if (this._dispenser != null) {
            this._dispenser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        DiskSearchIndex diskSearchIndex = this;
        synchronized (diskSearchIndex) {
            try {
                Object delDocs = this._delDocs;
                this.clearDeletes();
                this._dispenser.getNewReader();
                this.markDeletes((LongSet)delDocs);
                this.commitDeletes();
            }
            catch (IOException e) {
                ZoieHealth.setFatal();
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                Object object = this.readerOpenLock;
                synchronized (object) {
                    this.readerOpenLock.notifyAll();
                }
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public IndexWriter openIndexWriter(Analyzer analyzer, Similarity similarity) throws IOException {
        IndexWriter idxWriter;
        if (this._indexWriter != null) {
            return this._indexWriter;
        }
        Directory directory = this._dirMgr.getDirectory(true);
        log.info((Object)("opening index writer at: " + this._dirMgr.getPath()));
        ZoieMergePolicy mergePolicy = new ZoieMergePolicy();
        mergePolicy.setMergePolicyParams(this._mergePolicyParams);
        IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_34, analyzer);
        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        config.setIndexDeletionPolicy((IndexDeletionPolicy)this._deletionPolicy);
        config.setMergeScheduler(this._mergeScheduler);
        config.setMergePolicy((MergePolicy)mergePolicy);
        config.setReaderPooling(false);
        if (similarity != null) {
            config.setSimilarity(similarity);
        }
        config.setRAMBufferSizeMB(5.0);
        this._indexWriter = idxWriter = new IndexWriter(directory, config);
        return idxWriter;
    }

    @Override
    public ZoieIndexReader<R> openIndexReader() throws IOException {
        return this._dispenser.getIndexReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZoieIndexReader<R> openIndexReader(String minVersion, long timeout) throws IOException, TimeoutException {
        if (this._versionComparator.compare(minVersion, this._dispenser.getCurrentVersion()) <= 0) {
            return this._dispenser.getIndexReader();
        }
        long start = System.currentTimeMillis();
        while (this._versionComparator.compare(minVersion, this._dispenser.getCurrentVersion()) > 0) {
            Object object = this.readerOpenLock;
            synchronized (object) {
                try {
                    this.readerOpenLock.wait(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            long now = System.currentTimeMillis();
            if (now - start < timeout) continue;
            throw new TimeoutException("timed-out, took: " + (now - start) + " ms");
        }
        return this._dispenser.getIndexReader();
    }

    @Override
    protected IndexReader openIndexReaderForDelete() throws IOException {
        Directory directory = this._dirMgr.getDirectory(true);
        if (IndexReader.indexExists((Directory)directory)) {
            return IndexReader.open((Directory)directory, (IndexDeletionPolicy)this._deletionPolicy, (boolean)false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZoieIndexReader<R> getNewReader() throws IOException {
        DiskSearchIndex diskSearchIndex = this;
        synchronized (diskSearchIndex) {
            this.refresh();
            this.commitDeletes();
            ZoieIndexReader<R> reader = this._dispenser.getIndexReader();
            return reader;
        }
    }

    @Override
    public void setVersion(String version) throws IOException {
        this._dirMgr.setVersion(version);
    }

    public DiskIndexSnapshot getSnapshot() throws IOException {
        ZoieIndexDeletionPolicy.Snapshot snapshot;
        IndexSignature sig = new IndexSignature(this._dirMgr.getVersion());
        if (sig != null && (snapshot = this._deletionPolicy.getSnapshot()) != null) {
            return new DiskIndexSnapshot(this._dirMgr, sig, snapshot);
        }
        return null;
    }

    public void importSnapshot(ReadableByteChannel channel) throws IOException {
        DiskIndexSnapshot.readSnapshot(channel, this._dirMgr);
    }
}

