/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import proj.zoie.api.DirectoryManager;
import proj.zoie.api.DocIDMapper;
import proj.zoie.api.ZoieHealth;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.ZoieMultiReader;
import proj.zoie.api.indexing.IndexReaderDecorator;
import proj.zoie.impl.indexing.internal.DiskSearchIndex;
import proj.zoie.impl.indexing.internal.IndexSignature;

public class IndexReaderDispenser<R extends IndexReader> {
    private static final Logger log = Logger.getLogger(IndexReaderDispenser.class);
    private static final int INDEX_OPEN_NUM_RETRIES = 5;
    private volatile InternalIndexReader<R> _currentReader;
    private volatile IndexSignature _currentSignature;
    private final IndexReaderDecorator<R> _decorator;
    private final DirectoryManager _dirMgr;
    private DiskSearchIndex<R> _idx;

    public IndexReaderDispenser(DirectoryManager dirMgr, IndexReaderDecorator<R> decorator, DiskSearchIndex<R> idx) {
        this._idx = idx;
        this._dirMgr = dirMgr;
        this._decorator = decorator;
        this._currentSignature = null;
        try {
            IndexSignature sig = new IndexSignature(this._dirMgr.getVersion());
            if (sig != null) {
                this.getNewReader();
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public String getCurrentVersion() {
        return this._currentSignature != null ? this._currentSignature.getVersion() : null;
    }

    private InternalIndexReader<R> newReader(DirectoryManager dirMgr, IndexReaderDecorator<R> decorator, IndexSignature signature) throws IOException {
        if (!dirMgr.exists()) {
            return null;
        }
        Directory dir = dirMgr.getDirectory();
        if (!IndexReader.indexExists((Directory)dir)) {
            return null;
        }
        int numTries = 5;
        InternalIndexReader<R> reader = null;
        while (reader == null) {
            if (numTries == 0) {
                log.error((Object)"Problem refreshing disk index, all attempts failed.");
                throw new IOException("problem opening new index");
            }
            --numTries;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("opening index reader at: " + dirMgr.getPath()));
                }
                IndexReader srcReader = IndexReader.open((Directory)dir, (boolean)true);
                try {
                    reader = new InternalIndexReader<R>(srcReader, decorator);
                    this._currentSignature = signature;
                }
                catch (IOException ioe) {
                    if (srcReader != null) {
                        srcReader.close();
                    }
                    throw ioe;
                }
            }
            catch (IOException ioe) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    log.warn((Object)"thread interrupted.");
                }
            }
        }
        return reader;
    }

    public ZoieIndexReader<R> getNewReader() throws IOException {
        int numTries = 5;
        InternalIndexReader<R> reader = null;
        while (reader == null && numTries != 0) {
            --numTries;
            try {
                IndexSignature sig = new IndexSignature(this._dirMgr.getVersion());
                if (this._currentReader == null) {
                    reader = this.newReader(this._dirMgr, this._decorator, sig);
                    break;
                }
                reader = (InternalIndexReader)this._currentReader.reopen(true);
                this._currentSignature = sig;
            }
            catch (IOException ioe) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    log.warn((Object)"thread interrupted.");
                }
            }
        }
        if (this._currentReader != reader) {
            if (reader != null) {
                DocIDMapper<?> mapper = this._idx._idxMgr._docIDMapperFactory.getDocIDMapper(reader);
                reader.setDocIDMapper(mapper);
            }
            InternalIndexReader<R> oldReader = this._currentReader;
            this._currentReader = reader;
            log.info((Object)"swap disk reader and release old one from system");
            if (oldReader != null) {
                ((ZoieIndexReader)oldReader).decZoieRef();
            }
        }
        return reader;
    }

    public ZoieIndexReader<R> getIndexReader() {
        if (this._currentReader != null) {
            return this._currentReader;
        }
        return null;
    }

    public void close() {
        this.closeReader();
    }

    public void closeReader() {
        if (this._currentReader != null) {
            try {
                Directory directory = this._currentReader.directory();
                this._currentReader.decRef();
                int count = this._currentReader.getRefCount();
                log.info((Object)("final closeReader in dispenser and current refCount: " + count + " at " + directory));
                if (count > 0) {
                    log.warn((Object)("final closeReader call with reference count == " + count + " greater than 0. Potentially, " + "the IndexReaders are not properly return to ZoieSystem."));
                }
            }
            catch (IOException e) {
                ZoieHealth.setFatal();
                log.error((Object)"problem closing reader", (Throwable)e);
            }
            this._currentReader = null;
        }
    }

    static final class InternalIndexReader<R extends IndexReader>
    extends ZoieMultiReader<R> {
        InternalIndexReader(IndexReader in, IndexReaderDecorator<R> decorator) throws IOException {
            super(in, decorator);
        }

        public InternalIndexReader(IndexReader in, IndexReader[] subReaders, IndexReaderDecorator<R> decorator) throws IOException {
            super(in, subReaders, decorator);
        }

        @Override
        protected ZoieMultiReader<R> newInstance(IndexReader inner, IndexReader[] subReaders) throws IOException {
            return new InternalIndexReader<R>(inner, subReaders, this._decorator);
        }
    }
}

