/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.log4j.Logger;

public class IndexSignature {
    private static Logger log = Logger.getLogger(IndexSignature.class);
    private String _version;

    public IndexSignature(String version) {
        this._version = version;
    }

    public void updateVersion(String version) {
        this._version = version;
    }

    public String getVersion() {
        return this._version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream out) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
            if (this._version == null) {
                writer.write("null");
            } else {
                writer.write(this._version);
            }
            writer.flush();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexSignature read(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String line = null;
        try {
            line = reader.readLine();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            reader.close();
        }
        if (line != null && !line.equals("null")) {
            return new IndexSignature(line);
        }
        return new IndexSignature(null);
    }
}

