/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Similarity;
import proj.zoie.api.DataConsumer;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieHealth;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.ZoieSegmentReader;
import proj.zoie.api.indexing.IndexingEventListener;
import proj.zoie.api.indexing.ZoieIndexable;
import proj.zoie.impl.indexing.internal.BaseSearchIndex;
import proj.zoie.impl.indexing.internal.DiskSearchIndex;
import proj.zoie.impl.indexing.internal.RAMSearchIndex;
import proj.zoie.impl.indexing.internal.SearchIndexManager;

public abstract class LuceneIndexDataLoader<R extends IndexReader>
implements DataConsumer<ZoieIndexable> {
    private static final Logger log = Logger.getLogger(LuceneIndexDataLoader.class);
    protected final Analyzer _analyzer;
    protected final Similarity _similarity;
    protected final SearchIndexManager<R> _idxMgr;
    protected final Comparator<String> _versionComparator;
    private Filter _purgeFilter;
    private final Queue<IndexingEventListener> _lsnrList;

    protected LuceneIndexDataLoader(Analyzer analyzer, Similarity similarity, SearchIndexManager<R> idxMgr, Comparator<String> versionComparator, Queue<IndexingEventListener> lsnrList) {
        this._analyzer = analyzer;
        this._similarity = similarity;
        this._idxMgr = idxMgr;
        this._versionComparator = versionComparator;
        this._purgeFilter = null;
        this._lsnrList = lsnrList;
    }

    public void setPurgeFilter(Filter purgeFilter) {
        this._purgeFilter = purgeFilter;
    }

    protected abstract BaseSearchIndex<R> getSearchIndex();

    protected abstract void propagateDeletes(LongSet var1) throws IOException;

    protected abstract void commitPropagatedDeletes() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void purgeDocuments() {
        if (this._purgeFilter != null) {
            BaseSearchIndex<R> idx = this.getSearchIndex();
            IndexReader writeReader = null;
            log.info((Object)"purging docs started...");
            int count = 0;
            long start = System.currentTimeMillis();
            ZoieIndexReader<R> reader = null;
            try {
                int doc;
                BaseSearchIndex<R> baseSearchIndex = idx;
                synchronized (baseSearchIndex) {
                    reader = idx.openIndexReader();
                    if (reader != null) {
                        reader.incZoieRef();
                    }
                }
                writeReader = idx.openIndexReaderForDelete();
                DocIdSetIterator iter = this._purgeFilter.getDocIdSet(reader).iterator();
                while ((doc = iter.nextDoc()) != Integer.MAX_VALUE) {
                    ++count;
                    writeReader.deleteDocument(doc);
                }
            }
            catch (Throwable th) {
                log.error((Object)("problem creating purge filter: " + th.getMessage()), th);
            }
            finally {
                if (reader != null) {
                    reader.decZoieRef();
                }
                if (writeReader != null) {
                    try {
                        writeReader.close();
                    }
                    catch (IOException ioe) {
                        ZoieHealth.setFatal();
                        log.error((Object)ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
            long end = System.currentTimeMillis();
            log.info((Object)("purging docs completed in " + (end - start) + "ms"));
            log.info((Object)("total docs purged: " + count));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void consume(Collection<DataConsumer.DataEvent<ZoieIndexable>> events) throws ZoieException {
        if (events == null) {
            return;
        }
        int eventCount = events.size();
        if (eventCount == 0) {
            return;
        }
        BaseSearchIndex<R> idx = this.getSearchIndex();
        if (idx == null) {
            throw new ZoieException("trying to consume to null index");
        }
        Long2ObjectOpenHashMap addList = new Long2ObjectOpenHashMap();
        String version = idx.getVersion();
        LongOpenHashSet delSet = new LongOpenHashSet();
        try {
            for (DataConsumer.DataEvent<ZoieIndexable> evt : events) {
                ZoieIndexable indexable;
                if (evt == null) continue;
                String string = version == null ? evt.getVersion() : (version = this._versionComparator.compare(version, evt.getVersion()) < 0 ? evt.getVersion() : version);
                if (evt instanceof DataConsumer.MarkerDataEvent || (indexable = evt.getData()) == null || indexable.isSkip()) continue;
                long uid = indexable.getUID();
                delSet.add(uid);
                addList.remove(uid);
                if (indexable.isDeleted() || evt.isDelete()) continue;
                try {
                    ZoieIndexable.IndexingReq[] reqs;
                    for (ZoieIndexable.IndexingReq req : reqs = indexable.buildIndexingReqs()) {
                        LinkedList<ZoieIndexable.IndexingReq> docList;
                        if (req == null) continue;
                        Document doc = req.getDocument();
                        if (doc != null) {
                            byte[] bytes;
                            ZoieSegmentReader.fillDocumentID(doc, uid);
                            if (indexable.isStorable() && (bytes = indexable.getStoreValue()) != null) {
                                doc.add((Fieldable)new Field("_STORE", bytes));
                            }
                        }
                        if ((docList = (LinkedList<ZoieIndexable.IndexingReq>)addList.get(uid)) == null) {
                            docList = new LinkedList<ZoieIndexable.IndexingReq>();
                            addList.put(uid, docList);
                        }
                        docList.add(req);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("Couldn't index the event with uid - " + uid), (Throwable)ex);
                }
            }
            ArrayList<ZoieIndexable.IndexingReq> docList = new ArrayList<ZoieIndexable.IndexingReq>(addList.size());
            for (List tmpList : addList.values()) {
                docList.addAll(tmpList);
            }
            this.purgeDocuments();
            idx.updateIndex((LongSet)delSet, docList, this._analyzer, this._similarity);
            this.propagateDeletes((LongSet)delSet);
            SearchIndexManager<R> searchIndexManager = this._idxMgr;
            synchronized (searchIndexManager) {
                idx.refresh();
                this.commitPropagatedDeletes();
                return;
            }
        }
        catch (IOException ioe) {
            ZoieHealth.setFatal();
            log.error((Object)("Problem indexing batch: " + ioe.getMessage()), (Throwable)ioe);
            return;
        }
        finally {
            try {
                if (idx != null) {
                    idx.setVersion(version);
                    idx.incrementEventCount(eventCount);
                }
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
            finally {
                if (idx instanceof DiskSearchIndex) {
                    log.info((Object)"disk indexing requests flushed.");
                }
            }
        }
    }

    public void loadFromIndex(RAMSearchIndex<R> ramIndex) throws ZoieException {
        try {
            BaseSearchIndex<R> idx = this.getSearchIndex();
            idx.loadFromIndex(ramIndex);
            idx.refresh();
            this.purgeDocuments();
            idx.markDeletes(ramIndex.getDelDocs());
            idx.commitDeletes();
            idx.incrementEventCount(ramIndex.getEventsHandled());
            String newVersion = idx.getVersion() == null ? ramIndex.getVersion() : (this._versionComparator.compare(idx.getVersion(), ramIndex.getVersion()) < 0 ? ramIndex.getVersion() : idx.getVersion());
            idx.setVersion(newVersion);
        }
        catch (IOException ioe) {
            ZoieHealth.setFatal();
            log.error((Object)("Problem copying segments: " + ioe.getMessage()), (Throwable)ioe);
            throw new ZoieException(ioe);
        }
    }

    @Override
    public String getVersion() {
        BaseSearchIndex<R> idx = this.getSearchIndex();
        String version = null;
        if (idx != null) {
            version = idx.getVersion();
        }
        return version;
    }

    @Override
    public Comparator<String> getVersionComparator() {
        return this._versionComparator;
    }
}

