/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.Comparator;
import java.util.Queue;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Similarity;
import proj.zoie.api.indexing.IndexingEventListener;
import proj.zoie.impl.indexing.internal.BaseSearchIndex;
import proj.zoie.impl.indexing.internal.DiskSearchIndex;
import proj.zoie.impl.indexing.internal.LuceneIndexDataLoader;
import proj.zoie.impl.indexing.internal.RAMSearchIndex;
import proj.zoie.impl.indexing.internal.SearchIndexManager;

public class RAMLuceneIndexDataLoader<R extends IndexReader>
extends LuceneIndexDataLoader<R> {
    public RAMLuceneIndexDataLoader(Analyzer analyzer, Similarity similarity, SearchIndexManager<R> idxMgr, Comparator<String> comparator, Queue<IndexingEventListener> lsnrList) {
        super(analyzer, similarity, idxMgr, comparator, lsnrList);
    }

    @Override
    protected BaseSearchIndex<R> getSearchIndex() {
        return this._idxMgr.getCurrentWritableMemoryIndex();
    }

    @Override
    protected void propagateDeletes(LongSet delDocs) throws IOException {
        DiskSearchIndex diskIdx;
        if (delDocs == null || delDocs.size() == 0) {
            return;
        }
        RAMSearchIndex readOnlyMemoryIdx = this._idxMgr.getCurrentReadOnlyMemoryIndex();
        if (readOnlyMemoryIdx != null) {
            readOnlyMemoryIdx.markDeletes(delDocs);
        }
        if ((diskIdx = this._idxMgr.getDiskIndex()) != null) {
            diskIdx.markDeletes(delDocs);
        }
    }

    @Override
    protected void commitPropagatedDeletes() throws IOException {
        DiskSearchIndex diskIdx;
        RAMSearchIndex readOnlyMemoryIdx = this._idxMgr.getCurrentReadOnlyMemoryIndex();
        if (readOnlyMemoryIdx != null) {
            readOnlyMemoryIdx.commitDeletes();
        }
        if ((diskIdx = this._idxMgr.getDiskIndex()) != null) {
            diskIdx.commitDeletes();
        }
    }
}

