/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import proj.zoie.api.DocIDMapper;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.ZoieMultiReader;
import proj.zoie.api.impl.ZoieMergePolicy;
import proj.zoie.api.impl.util.FileUtil;
import proj.zoie.api.impl.util.IndexUtil;
import proj.zoie.api.indexing.IndexReaderDecorator;
import proj.zoie.impl.indexing.internal.BaseSearchIndex;
import proj.zoie.impl.indexing.internal.SearchIndexManager;

public class RAMSearchIndex<R extends IndexReader>
extends BaseSearchIndex<R> {
    private volatile String _version;
    private final Directory _directory;
    private final File _backingdir;
    private final IndexReaderDecorator<R> _decorator;
    private static ThreadLocal<IndexWriterConfig> indexWriterConfigStorage = new ThreadLocal();
    private volatile ZoieIndexReader<R> _currentReader;
    private final ZoieMergePolicy.MergePolicyParams _mergePolicyParams;
    public static final Logger log = Logger.getLogger(RAMSearchIndex.class);
    private final Object readerOpenLock = new Object();

    public RAMSearchIndex(String version, IndexReaderDecorator<R> decorator, SearchIndexManager<R> idxMgr, Directory ramIdxDir, File backingdir) {
        super(idxMgr, true);
        this._directory = ramIdxDir;
        this._backingdir = backingdir;
        this._version = version;
        this._decorator = decorator;
        this._currentReader = null;
        this._mergeScheduler = new SerialMergeScheduler();
        this._mergePolicyParams = new ZoieMergePolicy.MergePolicyParams();
        this._mergePolicyParams.setNumLargeSegments(3);
        this._mergePolicyParams.setMergeFactor(3);
        this._mergePolicyParams.setMaxSmallSegments(4);
    }

    @Override
    public void close() {
        super.close();
        if (this._currentReader != null) {
            this._currentReader.decZoieRef();
        }
        if (this._directory != null) {
            try {
                this._directory.close();
                if (this._backingdir != null) {
                    FileUtil.rmDir(this._backingdir);
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVersion(String version) throws IOException {
        this._version = version;
        Object object = this.readerOpenLock;
        synchronized (object) {
            this.readerOpenLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumdocs() {
        ZoieIndexReader<R> reader = null;
        try {
            RAMSearchIndex rAMSearchIndex = this;
            synchronized (rAMSearchIndex) {
                block11: {
                    reader = this.openIndexReader();
                    if (reader != null) break block11;
                    int n = 0;
                    return n;
                }
                reader.incZoieRef();
            }
            int n = reader.numDocs();
            return n;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.decZoieRef();
            }
        }
        return 0;
    }

    @Override
    public ZoieIndexReader<R> openIndexReader() throws IOException {
        return this._currentReader;
    }

    @Override
    protected IndexReader openIndexReaderForDelete() throws IOException {
        if (IndexReader.indexExists((Directory)this._directory)) {
            return IndexReader.open((Directory)this._directory, (boolean)false);
        }
        return null;
    }

    private ZoieIndexReader<R> openIndexReaderInternal() throws IOException {
        if (IndexReader.indexExists((Directory)this._directory)) {
            IndexReader srcReader = null;
            ZoieIndexReader<R> finalReader = null;
            try {
                srcReader = IndexReader.open((Directory)this._directory, (boolean)true);
                finalReader = ZoieIndexReader.open(srcReader, this._decorator);
                DocIDMapper<?> mapper = this._idxMgr._docIDMapperFactory.getDocIDMapper((ZoieMultiReader)finalReader);
                finalReader.setDocIDMapper(mapper);
                return finalReader;
            }
            catch (IOException ioe) {
                if (srcReader != null) {
                    srcReader.close();
                }
                throw ioe;
            }
        }
        return null;
    }

    @Override
    public IndexWriter openIndexWriter(Analyzer analyzer, Similarity similarity) throws IOException {
        IndexWriter idxWriter;
        if (this._indexWriter != null) {
            return this._indexWriter;
        }
        ZoieMergePolicy mergePolicy = new ZoieMergePolicy();
        mergePolicy.setMergePolicyParams(this._mergePolicyParams);
        mergePolicy.setUseCompoundFile(false);
        IndexWriterConfig config = indexWriterConfigStorage.get();
        if (config == null) {
            config = new IndexWriterConfig(Version.LUCENE_34, analyzer);
            indexWriterConfigStorage.set(config);
        }
        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        config.setMergeScheduler(this._mergeScheduler);
        config.setMergePolicy((MergePolicy)mergePolicy);
        config.setReaderPooling(false);
        if (similarity != null) {
            config.setSimilarity(similarity);
        }
        config.setRAMBufferSizeMB(3.0);
        this._indexWriter = idxWriter = new IndexWriter(this._directory, config);
        return idxWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZoieIndexReader<R> openIndexReader(String minVersion, long timeout) throws IOException, TimeoutException {
        if (timeout < 0L) {
            timeout = Long.MAX_VALUE;
        }
        if (this._versionComparator.compare(minVersion, this._version) <= 0) {
            return this._currentReader;
        }
        long startTimer = System.currentTimeMillis();
        while (this._versionComparator.compare(minVersion, this._version) > 0) {
            Object object = this.readerOpenLock;
            synchronized (object) {
                try {
                    this.readerOpenLock.wait(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            long now = System.currentTimeMillis();
            if (now - startTimer < timeout) continue;
            throw new TimeoutException("timed-out, took: " + (now - startTimer) + " ms");
        }
        return this._currentReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws IOException {
        RAMSearchIndex rAMSearchIndex = this;
        synchronized (rAMSearchIndex) {
            ZoieIndexReader reader = null;
            if (this._currentReader == null) {
                reader = this.openIndexReaderInternal();
            } else {
                reader = (ZoieIndexReader)this._currentReader.reopen(true);
                if (reader != this._currentReader) {
                    DocIDMapper<?> mapper = this._idxMgr._docIDMapperFactory.getDocIDMapper((ZoieMultiReader)reader);
                    reader.setDocIDMapper(mapper);
                }
            }
            if (this._currentReader != reader) {
                ZoieIndexReader<R> oldReader = this._currentReader;
                this._currentReader = reader;
                if (oldReader != null) {
                    oldReader.decZoieRef();
                }
            }
            LongOpenHashSet delDocs = this._delDocs;
            this.clearDeletes();
            this.markDeletes((LongSet)delDocs);
            this.commitDeletes();
        }
    }

    public int getSegmentCount() throws IOException {
        return this._directory == null ? -1 : IndexUtil.getNumSegments(this._directory);
    }
}

