/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Similarity;
import proj.zoie.api.DataConsumer;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieHealth;
import proj.zoie.api.indexing.IndexingEventListener;
import proj.zoie.api.indexing.ZoieIndexable;
import proj.zoie.api.indexing.ZoieIndexableInterpreter;
import proj.zoie.impl.indexing.IndexUpdatedEvent;
import proj.zoie.impl.indexing.internal.BatchedIndexDataLoader;
import proj.zoie.impl.indexing.internal.DiskLuceneIndexDataLoader;
import proj.zoie.impl.indexing.internal.RAMLuceneIndexDataLoader;
import proj.zoie.impl.indexing.internal.RAMSearchIndex;
import proj.zoie.impl.indexing.internal.SearchIndexManager;

public class RealtimeIndexDataLoader<R extends IndexReader, D>
extends BatchedIndexDataLoader<R, D> {
    private int _currentBatchSize;
    private final DataConsumer<ZoieIndexable> _ramConsumer;
    private final DiskLuceneIndexDataLoader<R> _luceneDataLoader;
    private final Analyzer _analyzer;
    private final Similarity _similarity;
    private static Logger log = Logger.getLogger(RealtimeIndexDataLoader.class);

    public RealtimeIndexDataLoader(DiskLuceneIndexDataLoader<R> dataLoader, int batchSize, int maxBatchSize, long delay, Analyzer analyzer, Similarity similarity, SearchIndexManager<R> idxMgr, ZoieIndexableInterpreter<D> interpreter, Queue<IndexingEventListener> lsnrList, Comparator<String> comparator) {
        super(dataLoader, batchSize, maxBatchSize, delay, idxMgr, interpreter, lsnrList);
        this._analyzer = analyzer;
        this._similarity = similarity;
        this._currentBatchSize = 0;
        this._ramConsumer = new RAMLuceneIndexDataLoader(this._analyzer, this._similarity, this._idxMgr, comparator, lsnrList);
        this._luceneDataLoader = dataLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(Collection<DataConsumer.DataEvent<D>> events) throws ZoieException {
        if (events != null) {
            Object newEvent;
            ArrayList indexableList = new ArrayList(events.size());
            Iterator<DataConsumer.DataEvent<D>> iter = events.iterator();
            while (iter.hasNext()) {
                try {
                    DataConsumer.DataEvent<D> event = iter.next();
                    ZoieIndexable indexable = this._interpreter.convertAndInterpret(event.getData());
                    newEvent = new DataConsumer.DataEvent<ZoieIndexable>(indexable, event.getVersion(), event.isDelete());
                    indexableList.add(newEvent);
                }
                catch (Exception e) {
                    ZoieHealth.setFatal();
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            RealtimeIndexDataLoader realtimeIndexDataLoader = this;
            synchronized (realtimeIndexDataLoader) {
                int size = indexableList.size();
                newEvent = this._idxMgr;
                synchronized (newEvent) {
                    this._ramConsumer.consume(indexableList);
                }
                this._currentBatchSize += size;
                this._eventCount += size;
                while (this._currentBatchSize > this._maxBatchSize) {
                    if (this._loadMgrThread == null || !this._loadMgrThread.isAlive()) {
                        ZoieHealth.setFatal();
                        throw new ZoieException("fatal: indexing thread loader manager has stopped");
                    }
                    this.notifyAll();
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException e) {}
                }
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized int getCurrentBatchSize() {
        return this._currentBatchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processBatch() {
        RAMSearchIndex readOnlyMemIndex = null;
        int eventCount = 0;
        RealtimeIndexDataLoader realtimeIndexDataLoader = this;
        synchronized (realtimeIndexDataLoader) {
            long now = System.currentTimeMillis();
            long duration = now - this._lastFlushTime;
            while (this._currentBatchSize < this._batchSize && !this._stop && !this._flush && duration < this._delay) {
                try {
                    this.wait(this._delay - duration);
                }
                catch (InterruptedException e) {
                    log.warn((Object)e.getMessage());
                }
                now = System.currentTimeMillis();
                duration = now - this._lastFlushTime;
            }
            this._flush = false;
            this._lastFlushTime = now;
            if (this._currentBatchSize > 0) {
                this._idxMgr.setDiskIndexerStatus(SearchIndexManager.Status.Working);
                readOnlyMemIndex = this._idxMgr.getCurrentReadOnlyMemoryIndex();
                eventCount = this._currentBatchSize;
                this._currentBatchSize = 0;
            }
            this.notifyAll();
        }
        if (eventCount > 0) {
            long t1 = System.currentTimeMillis();
            try {
                if (readOnlyMemIndex == null) return;
                this._luceneDataLoader.loadFromIndex(readOnlyMemIndex);
                return;
            }
            catch (ZoieException e) {
                ZoieHealth.setFatal();
                log.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
            finally {
                RealtimeIndexDataLoader realtimeIndexDataLoader2 = this;
                synchronized (realtimeIndexDataLoader2) {
                    long t2 = System.currentTimeMillis();
                    this._eventCount -= eventCount;
                    int segmentCount = -1;
                    String segmentInfo = "";
                    try {
                        segmentCount = this._idxMgr.getDiskSegmentCount();
                        segmentInfo = this._idxMgr.getDiskSegmentInfo();
                        IndexUpdatedEvent evt = new IndexUpdatedEvent(eventCount, t1, t2, this._eventCount);
                        this.fireIndexingEvent(evt);
                        this.fireNewVersionEvent(readOnlyMemIndex.getVersion());
                    }
                    catch (IOException e) {
                        log.error((Object)"error getting disk information after disk flush", (Throwable)e);
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)("flushed batch of " + eventCount + " events to disk indexer, took: " + (t2 - t1) + " current event count: " + this._eventCount + ", current disk segment count: " + segmentCount));
                        log.info((Object)("post-flush segment info: " + segmentInfo));
                    }
                    this.notifyAll();
                }
            }
        }
        if (!log.isDebugEnabled()) return;
        log.debug((Object)"batch size is 0");
    }
}

