/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import proj.zoie.api.DirectoryManager;
import proj.zoie.api.DocIDMapperFactory;
import proj.zoie.api.IndexReaderFactory;
import proj.zoie.api.ZoieHealth;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.indexing.IndexReaderDecorator;
import proj.zoie.impl.indexing.internal.DiskSearchIndex;
import proj.zoie.impl.indexing.internal.RAMIndexFactory;
import proj.zoie.impl.indexing.internal.RAMSearchIndex;

public class SearchIndexManager<R extends IndexReader>
implements IndexReaderFactory<ZoieIndexReader<R>> {
    private static final Logger log = Logger.getLogger(SearchIndexManager.class);
    private DirectoryManager _dirMgr;
    private final IndexReaderDecorator<R> _indexReaderDecorator;
    final DocIDMapperFactory _docIDMapperFactory;
    private final DiskSearchIndex<R> _diskIndex;
    private volatile Status _diskIndexerStatus;
    private volatile Mem<R> _mem;
    private final Object _memLock = new Object();
    private final RAMIndexFactory<R> _ramIndexFactory;
    private volatile String _memAVersion = null;
    private volatile String _memBVersion = null;
    private volatile String _diskVersion = null;
    private final Comparator<String> _versionComparator;

    public SearchIndexManager(DirectoryManager dirMgr, Comparator<String> versionComparator, IndexReaderDecorator<R> indexReaderDecorator, DocIDMapperFactory docIDMapperFactory, RAMIndexFactory<R> ramIndexFactory) {
        this._dirMgr = dirMgr;
        this._versionComparator = versionComparator;
        this._docIDMapperFactory = docIDMapperFactory;
        this._ramIndexFactory = ramIndexFactory;
        if (indexReaderDecorator == null) {
            throw new IllegalArgumentException("indexReaderDecorator cannot be null");
        }
        this._indexReaderDecorator = indexReaderDecorator;
        this._diskIndexerStatus = Status.Sleep;
        this._diskIndex = new DiskSearchIndex<R>(this._dirMgr, this._indexReaderDecorator, this);
        ZoieIndexReader<R> diskIndexReader = null;
        try {
            diskIndexReader = this._diskIndex.getNewReader();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        String version = this._diskIndex.getVersion();
        RAMSearchIndex<R> memIndexA = this._ramIndexFactory.newInstance(version, this._indexReaderDecorator, this);
        Mem<R> mem = new Mem<R>(memIndexA, null, memIndexA, null, diskIndexReader);
        if (diskIndexReader != null) {
            diskIndexReader.incZoieRef();
        }
        this._mem = mem;
    }

    public DocIDMapperFactory getDocIDMapperFactory() {
        return this._docIDMapperFactory;
    }

    public int getDiskSegmentCount() throws IOException {
        return this._diskIndex.getSegmentCount();
    }

    public String getDiskSegmentInfo() {
        return this._diskIndex.getSegmentInfo();
    }

    public int getRAMASegmentCount() {
        int ret;
        Mem<R> mem = this._mem;
        if (mem.get_memIndexA() == null) {
            return -1;
        }
        try {
            ret = mem.get_memIndexA().getSegmentCount();
        }
        catch (IOException e) {
            ret = -1;
        }
        return ret;
    }

    public int getRAMBSegmentCount() {
        int ret;
        Mem<R> mem = this._mem;
        if (mem.get_memIndexB() == null) {
            return -1;
        }
        try {
            ret = mem.get_memIndexB().getSegmentCount();
        }
        catch (IOException e) {
            ret = -1;
        }
        return ret;
    }

    public void setNumLargeSegments(int numLargeSegments) {
        this._diskIndex._mergePolicyParams.setNumLargeSegments(numLargeSegments);
    }

    public int getNumLargeSegments() {
        return this._diskIndex._mergePolicyParams.getNumLargeSegments();
    }

    public void setMaxSmallSegments(int maxSmallSegments) {
        this._diskIndex._mergePolicyParams.setMaxSmallSegments(maxSmallSegments);
    }

    public int getMaxSmallSegments() {
        return this._diskIndex._mergePolicyParams.getMaxSmallSegments();
    }

    public void setPartialExpunge(boolean doPartialExpunge) {
        this._diskIndex._mergePolicyParams.setPartialExpunge(doPartialExpunge);
    }

    public boolean getPartialExpunge() {
        return this._diskIndex._mergePolicyParams.getPartialExpunge();
    }

    public void setMergeFactor(int mergeFactor) {
        this._diskIndex._mergePolicyParams.setMergeFactor(mergeFactor);
    }

    public int getMergeFactor() {
        return this._diskIndex._mergePolicyParams.getMergeFactor();
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this._diskIndex._mergePolicyParams.setMaxMergeDocs(maxMergeDocs);
    }

    public int getMaxMergeDocs() {
        return this._diskIndex._mergePolicyParams.getMaxMergeDocs();
    }

    public void setUseCompoundFile(boolean useCompoundFile) {
        this._diskIndex._mergePolicyParams.setUseCompoundFile(useCompoundFile);
    }

    public boolean isUseCompoundFile() {
        return this._diskIndex._mergePolicyParams.isUseCompoundFile();
    }

    public Status getDiskIndexerStatus() {
        return this._diskIndexerStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ZoieIndexReader<R>> getIndexReaders() throws IOException {
        ArrayList<ZoieIndexReader<R>> readers = new ArrayList<ZoieIndexReader<R>>();
        ZoieIndexReader<R> reader = null;
        SearchIndexManager searchIndexManager = this;
        synchronized (searchIndexManager) {
            Object object = this._memLock;
            synchronized (object) {
                RAMSearchIndex<R> rAMSearchIndex;
                Mem<R> mem = this._mem;
                RAMSearchIndex<R> memIndexB = mem.get_memIndexB();
                RAMSearchIndex<R> memIndexA = mem.get_memIndexA();
                Object currentVersion = null;
                if (memIndexB != null) {
                    rAMSearchIndex = memIndexB;
                    synchronized (rAMSearchIndex) {
                        reader = memIndexB.openIndexReader();
                        if (reader != null) {
                            reader = reader.copy();
                            reader.setDelDocIds();
                            readers.add(reader);
                        }
                    }
                    this._memBVersion = memIndexB.getVersion();
                }
                if (memIndexA != null) {
                    rAMSearchIndex = memIndexA;
                    synchronized (rAMSearchIndex) {
                        reader = memIndexA.openIndexReader();
                        if (reader != null) {
                            reader = reader.copy();
                            reader.setDelDocIds();
                            readers.add(reader);
                        }
                    }
                    this._memAVersion = memIndexA.getVersion();
                }
                if ((reader = mem.get_diskIndexReader()) != null) {
                    reader = reader.copy();
                    reader.setDelDocIds();
                    readers.add(reader);
                }
                this._diskVersion = this.getCurrentDiskVersion();
            }
        }
        return readers;
    }

    @Override
    public String getCurrentReaderVersion() {
        String version = this._memAVersion;
        if (this._versionComparator.compare(version, this._memBVersion) < 0) {
            version = this._memBVersion;
        }
        if (this._versionComparator.compare(version, this._diskVersion) < 0) {
            version = this._diskVersion;
        }
        return version;
    }

    public Comparator<String> getVersionComparator() {
        return this._versionComparator;
    }

    @Override
    public void returnIndexReaders(List<ZoieIndexReader<R>> readers) {
        for (ZoieIndexReader<R> r : readers) {
            r.decZoieRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDiskIndexerStatus(Status status) {
        if (this._diskIndexerStatus != status) {
            log.info((Object)("updating batch indexer status from " + (Object)((Object)this._diskIndexerStatus) + " to " + (Object)((Object)status)));
            if (status == Status.Working) {
                String version = this._diskIndex.getVersion();
                Mem<R> oldMem = this._mem;
                RAMSearchIndex<R> memIndexA = oldMem.get_memIndexA();
                if (memIndexA != null) {
                    memIndexA.closeIndexWriter();
                }
                RAMSearchIndex<R> memIndexB = this._ramIndexFactory.newInstance(version, this._indexReaderDecorator, this);
                Mem<R> mem = new Mem<R>(memIndexA, memIndexB, memIndexB, memIndexA, oldMem.get_diskIndexReader());
                Object object = this._memLock;
                synchronized (object) {
                    this._mem = mem;
                }
                log.info((Object)"Current writable index is B, new B created");
            } else {
                ZoieIndexReader<R> diskIndexReader = null;
                try {
                    Object oldMem = this._diskIndex;
                    synchronized (oldMem) {
                        diskIndexReader = this._diskIndex.openIndexReader();
                        if (diskIndexReader != null) {
                            diskIndexReader.incZoieRef();
                        }
                    }
                    oldMem = this._mem;
                    Mem mem = new Mem(((Mem)oldMem).get_memIndexB(), null, ((Mem)oldMem).get_memIndexB(), null, diskIndexReader);
                    if (((Mem)oldMem).get_memIndexA() != null) {
                        ((Mem)oldMem).get_memIndexA().close();
                    }
                    this.lockAndSwapMem(diskIndexReader, ((Mem)oldMem).get_diskIndexReader(), mem);
                    log.info((Object)"Current writable index is A, B is flushed");
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
                finally {
                    if (diskIndexReader != null) {
                        diskIndexReader.decZoieRef();
                    }
                }
            }
            this._diskIndexerStatus = status;
        }
    }

    public DiskSearchIndex<R> getDiskIndex() {
        return this._diskIndex;
    }

    public RAMSearchIndex<R> getCurrentWritableMemoryIndex() {
        return this._mem.get_currentWritable();
    }

    public RAMSearchIndex<R> getCurrentReadOnlyMemoryIndex() {
        return this._mem.get_currentReadOnly();
    }

    public void close() {
        Mem<R> mem = this._mem;
        if (mem.get_memIndexA() != null) {
            mem.get_memIndexA().close();
        }
        if (mem.get_memIndexB() != null) {
            mem.get_memIndexB().close();
        }
        if (mem.get_diskIndexReader() != null) {
            mem.get_diskIndexReader().decZoieRef();
            this._diskIndex.close();
        }
    }

    public String getCurrentDiskVersion() throws IOException {
        return this._diskIndex.getVersion();
    }

    public int getDiskIndexSize() {
        return this._diskIndex.getNumdocs();
    }

    public int getRamAIndexSize() {
        RAMSearchIndex<R> memIndexA = this._mem.get_memIndexA();
        return memIndexA == null ? 0 : memIndexA.getNumdocs();
    }

    public String getRamAVersion() {
        RAMSearchIndex<R> memIndexA = this._mem.get_memIndexA();
        return memIndexA == null ? null : memIndexA.getVersion();
    }

    public int getRamBIndexSize() {
        RAMSearchIndex<R> memIndexB = this._mem.get_memIndexB();
        return memIndexB == null ? 0 : memIndexB.getNumdocs();
    }

    public String getRamBVersion() {
        RAMSearchIndex<R> memIndexB = this._mem.get_memIndexB();
        return memIndexB == null ? null : memIndexB.getVersion();
    }

    private static void deleteDir(File dir) throws IOException {
        if (dir == null) {
            return;
        }
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                SearchIndexManager.deleteDir(file);
            }
            if (!dir.delete()) {
                throw new IOException("cannot remove directory: " + dir.getAbsolutePath());
            }
        } else if (!dir.delete()) {
            throw new IOException("cannot delete file: " + dir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeIndex() {
        log.info((Object)"purging index ...");
        this._diskIndex.clearDeletes();
        this._diskIndex.refresh();
        this._diskIndex.closeIndexWriter();
        this._dirMgr.purge();
        this._diskIndex.refresh();
        if (this._mem.get_memIndexA() != null) {
            this._mem.get_memIndexA().close();
        }
        if (this._mem.get_memIndexB() != null) {
            this._mem.get_memIndexB().close();
        }
        RAMSearchIndex<R> memIndexA = this._ramIndexFactory.newInstance(this._diskIndex.getVersion(), this._indexReaderDecorator, this);
        Mem<R> mem = new Mem<R>(memIndexA, null, memIndexA, null, null);
        Object object = this._memLock;
        synchronized (object) {
            this._mem = mem;
        }
        log.info((Object)"index purged");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDiskReader() throws IOException {
        log.info((Object)"refreshing disk reader ...");
        ZoieIndexReader<R> diskIndexReader = null;
        try {
            diskIndexReader = this._diskIndex.getNewReader();
        }
        catch (IOException e) {
            ZoieHealth.setFatal();
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        Object object = this._memLock;
        synchronized (object) {
            Mem<R> oldMem = this._mem;
            ZoieIndexReader<R> oldDiskIndexReader = oldMem.get_diskIndexReader();
            if (diskIndexReader != oldDiskIndexReader) {
                Mem<R> mem = new Mem<R>(oldMem.get_memIndexA(), oldMem.get_memIndexB(), oldMem.get_currentWritable(), oldMem.get_currentReadOnly(), diskIndexReader);
                if (oldDiskIndexReader != null) {
                    oldDiskIndexReader.decZoieRef();
                }
                diskIndexReader.incZoieRef();
                this._mem = mem;
            }
        }
        log.info((Object)"disk reader refreshed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAndSwapMem(ZoieIndexReader<R> diskIndexReader, ZoieIndexReader<R> oldDiskReader, Mem<R> mem) {
        Object object = this._memLock;
        synchronized (object) {
            if (oldDiskReader != diskIndexReader) {
                if (oldDiskReader != null) {
                    oldDiskReader.decZoieRef();
                }
                diskIndexReader.incZoieRef();
            }
            this._mem = mem;
        }
    }

    @Override
    public Analyzer getAnalyzer() {
        throw new UnsupportedOperationException();
    }

    private static final class Mem<R extends IndexReader> {
        private final RAMSearchIndex<R> _memIndexA;
        private final RAMSearchIndex<R> _memIndexB;
        private final RAMSearchIndex<R> _currentWritable;
        private final RAMSearchIndex<R> _currentReadOnly;
        private final ZoieIndexReader<R> _diskIndexReader;

        Mem(RAMSearchIndex<R> a, RAMSearchIndex<R> b, RAMSearchIndex<R> w, RAMSearchIndex<R> r, ZoieIndexReader<R> d) {
            this._memIndexA = a;
            this._memIndexB = b;
            this._currentWritable = w;
            this._currentReadOnly = r;
            this._diskIndexReader = d;
        }

        protected RAMSearchIndex<R> get_memIndexA() {
            return this._memIndexA;
        }

        protected RAMSearchIndex<R> get_memIndexB() {
            return this._memIndexB;
        }

        protected RAMSearchIndex<R> get_currentWritable() {
            return this._currentWritable;
        }

        protected RAMSearchIndex<R> get_currentReadOnly() {
            return this._currentReadOnly;
        }

        protected ZoieIndexReader<R> get_diskIndexReader() {
            return this._diskIndexReader;
        }
    }

    public static enum Status {
        Sleep,
        Working;

    }
}

