/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;

public class ZoieIndexDeletionPolicy
implements IndexDeletionPolicy {
    private IndexCommit _lastCommit = null;
    private HashMap<String, Snapshot> _currentSnapshots = new HashMap();

    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        this.processCommits(commits);
    }

    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        this.processCommits(commits);
    }

    private synchronized void processCommits(List<? extends IndexCommit> commits) {
        int size = commits.size();
        if (size == 0) {
            return;
        }
        IndexCommit indexCommit = null;
        Iterator<? extends IndexCommit> i$ = commits.iterator();
        while (i$.hasNext()) {
            IndexCommit commit;
            indexCommit = commit = i$.next();
            if (--size <= 0 || this._currentSnapshots.containsKey(indexCommit.getSegmentsFileName())) continue;
            indexCommit.delete();
        }
        this._lastCommit = indexCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Snapshot getSnapshot() {
        Snapshot snapshot;
        if (this._lastCommit == null) {
            return null;
        }
        HashMap<String, Snapshot> hashMap = this._currentSnapshots;
        synchronized (hashMap) {
            String name = this._lastCommit.getSegmentsFileName();
            snapshot = this._currentSnapshots.get(name);
            if (snapshot == null) {
                snapshot = new Snapshot(this._lastCommit);
                this._currentSnapshots.put(name, snapshot);
            } else {
                snapshot.incRef();
            }
        }
        return snapshot;
    }

    public class Snapshot {
        private final IndexCommit _commit;
        private int _refcount;

        public Snapshot(IndexCommit commit) {
            this._commit = commit;
            this._refcount = 1;
        }

        public Collection<String> getFileNames() throws IOException {
            return this._commit.getFileNames();
        }

        public void close() {
            this.decRef();
        }

        private synchronized void incRef() {
            ++this._refcount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void decRef() {
            if (--this._refcount <= 0) {
                HashMap hashMap = ZoieIndexDeletionPolicy.this._currentSnapshots;
                synchronized (hashMap) {
                    ZoieIndexDeletionPolicy.this._currentSnapshots.remove(this._commit.getSegmentsFileName());
                }
            }
        }

        public void finalize() {
            this._refcount = 0;
            this.close();
        }
    }
}

