/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.internal;

import java.io.IOException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class ZoieSegmentTermDocs
extends FilterIndexReader.FilterTermDocs {
    private final DocIdSet delSet;
    private int _firstDelDoc = -1;
    private DocIdSetIterator _delSetIterator;
    private int _nextDelDoc;

    public ZoieSegmentTermDocs(TermDocs in, DocIdSet delSet) throws IOException {
        super(in);
        this.delSet = delSet;
        this.resetDelIter();
        this._firstDelDoc = this._nextDelDoc;
    }

    private final void resetDelIter() throws IOException {
        if (this._firstDelDoc != this._nextDelDoc) {
            this._delSetIterator = this.delSet.iterator();
            this._nextDelDoc = this._delSetIterator.nextDoc();
        }
    }

    public void seek(Term term) throws IOException {
        this.resetDelIter();
        super.seek(term);
    }

    public void seek(TermEnum termEnum) throws IOException {
        this.resetDelIter();
        super.seek(termEnum);
    }

    public boolean next() throws IOException {
        boolean hasNext = this.in.next();
        if (this._nextDelDoc != Integer.MAX_VALUE) {
            int currID = this.in.doc();
            while (hasNext) {
                if (currID < this._nextDelDoc) {
                    return hasNext;
                }
                if (currID == this._nextDelDoc) {
                    hasNext = this.in.next();
                    currID = this.in.doc();
                }
                this._nextDelDoc = this._delSetIterator.advance(currID);
            }
        }
        return hasNext;
    }

    public int read(int[] docs, int[] freqs) throws IOException {
        if (this._nextDelDoc != Integer.MAX_VALUE) {
            int i = 0;
            while (i < docs.length) {
                if (!this.in.next()) {
                    return i;
                }
                int doc = this.in.doc();
                if (doc < this._nextDelDoc) {
                    docs[i] = doc;
                    freqs[i] = this.in.freq();
                    ++i;
                    continue;
                }
                this._nextDelDoc = this._delSetIterator.advance(doc);
                if (doc == this._nextDelDoc) continue;
                docs[i] = doc;
                freqs[i] = this.in.freq();
                ++i;
            }
            return i;
        }
        return this.in.read(docs, freqs);
    }

    public boolean skipTo(int i) throws IOException {
        if (!this.in.skipTo(i)) {
            return false;
        }
        if (this._nextDelDoc != Integer.MAX_VALUE) {
            int doc = this.in.doc();
            if (doc < this._nextDelDoc) {
                return true;
            }
            this._nextDelDoc = this._delSetIterator.advance(doc);
            if (doc == this._nextDelDoc) {
                return this.next();
            }
        }
        return true;
    }
}

