/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.impl.indexing.luceneNRT;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import proj.zoie.api.DataConsumer;
import proj.zoie.api.IndexReaderFactory;
import proj.zoie.api.ZoieException;
import proj.zoie.api.indexing.ZoieIndexable;
import proj.zoie.api.indexing.ZoieIndexableInterpreter;

public class LuceneNRTDataConsumer<D>
implements DataConsumer<D>,
IndexReaderFactory<IndexReader> {
    private static final Logger logger = Logger.getLogger(LuceneNRTDataConsumer.class);
    public static final String DOCUMENT_ID_FIELD = "id";
    private IndexWriter _writer = null;
    private Analyzer _analyzer;
    private ZoieIndexableInterpreter<D> _interpreter;
    private Directory _dir;
    private volatile String _currentReaderVersion = null;

    public LuceneNRTDataConsumer(File dir, ZoieIndexableInterpreter<D> interpreter) throws IOException {
        this((Directory)FSDirectory.open((File)dir), (Analyzer)new StandardAnalyzer(Version.LUCENE_34), interpreter);
    }

    public LuceneNRTDataConsumer(File dir, Analyzer analyzer, ZoieIndexableInterpreter<D> interpreter) throws IOException {
        this((Directory)FSDirectory.open((File)dir), analyzer, interpreter);
    }

    public LuceneNRTDataConsumer(Directory dir, Analyzer analyzer, ZoieIndexableInterpreter<D> interpreter) {
        this._analyzer = analyzer;
        this._interpreter = interpreter;
        this._dir = dir;
    }

    public void start() {
        try {
            IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_34, this._analyzer);
            this._writer = new IndexWriter(this._dir, config);
        }
        catch (IOException e) {
            logger.error((Object)("uanble to start consumer: " + e.getMessage()), (Throwable)e);
        }
    }

    public void shutdown() {
        if (this._writer != null) {
            try {
                this._writer.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void consume(Collection<DataConsumer.DataEvent<D>> events) throws ZoieException {
        if (this._writer == null) {
            throw new ZoieException("Internal IndexWriter null, perhaps not started?");
        }
        if (events.size() > 0) {
            String version = null;
            for (DataConsumer.DataEvent<D> event : events) {
                ZoieIndexable.IndexingReq[] reqs;
                ZoieIndexable indexable = this._interpreter.convertAndInterpret(event.getData());
                version = event.getVersion();
                if (indexable.isSkip()) continue;
                try {
                    this._writer.deleteDocuments(new Term(DOCUMENT_ID_FIELD, String.valueOf(indexable.getUID())));
                }
                catch (IOException e) {
                    throw new ZoieException(e.getMessage(), e);
                }
                for (ZoieIndexable.IndexingReq req : reqs = indexable.buildIndexingReqs()) {
                    Analyzer localAnalyzer = req.getAnalyzer();
                    Document doc = req.getDocument();
                    Field uidField = new Field(DOCUMENT_ID_FIELD, String.valueOf(indexable.getUID()), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
                    uidField.setOmitNorms(true);
                    doc.add((Fieldable)uidField);
                    if (localAnalyzer == null) {
                        localAnalyzer = this._analyzer;
                    }
                    try {
                        this._writer.addDocument(doc, localAnalyzer);
                    }
                    catch (IOException e) {
                        throw new ZoieException(e.getMessage(), e);
                    }
                }
            }
            if (version != null) {
                HashMap<String, String> versionData = new HashMap<String, String>();
                versionData.put("version", version);
                try {
                    this._writer.commit(versionData);
                }
                catch (IOException e) {
                    throw new ZoieException(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public Analyzer getAnalyzer() {
        return this._analyzer;
    }

    @Override
    public String getCurrentReaderVersion() {
        return this._currentReaderVersion;
    }

    public IndexReader getDiskIndexReader() throws IOException {
        if (this._writer != null) {
            IndexReader reader = IndexReader.open((IndexWriter)this._writer, (boolean)true);
            Map userData = reader.getCommitUserData();
            if (userData != null) {
                this._currentReaderVersion = (String)userData.get("version");
            }
            return reader;
        }
        return null;
    }

    @Override
    public List<IndexReader> getIndexReaders() throws IOException {
        IndexReader subReader = this.getDiskIndexReader();
        ArrayList<IndexReader> list = new ArrayList<IndexReader>();
        if (subReader != null) {
            list.add(subReader);
        }
        return list;
    }

    @Override
    public void returnIndexReaders(List<IndexReader> readers) {
        if (readers != null) {
            for (IndexReader r : readers) {
                try {
                    r.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<String> getVersionComparator() {
        throw new UnsupportedOperationException();
    }
}

