/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.mbean;

import java.util.Date;
import proj.zoie.api.indexing.IndexingEventListener;
import proj.zoie.impl.indexing.IndexUpdatedEvent;
import proj.zoie.impl.indexing.ZoieSystem;
import proj.zoie.mbean.ZoieIndexingStatusAdminMBean;

public class ZoieIndexingStatusAdmin
implements ZoieIndexingStatusAdminMBean,
IndexingEventListener {
    private final ZoieSystem<?, ?> _zoieSystem;
    private long _endTime;
    private long _startTime;
    private int _leftOver;
    private int _size;
    private long _totalTime;
    private int _totalSize;
    private String _diskVersion;

    public ZoieIndexingStatusAdmin(ZoieSystem<?, ?> zoieSystem) {
        this._zoieSystem = zoieSystem;
        this._zoieSystem.addIndexingEventListener(this);
        this._startTime = 0L;
        this._endTime = 0L;
        this._leftOver = 0;
        this._size = 0;
        this._totalSize = 0;
        this._totalTime = 0L;
        this._diskVersion = null;
    }

    @Override
    public long getAverageIndexingBatchDuration() {
        return this._totalSize == 0 ? 0L : this._totalTime / (long)this._totalSize;
    }

    @Override
    public long getLastIndexingBatchDuration() {
        return this._endTime - this._startTime;
    }

    @Override
    public int getLastIndexingBatchLeftOver() {
        return this._leftOver;
    }

    @Override
    public int getLastIndexingBatchSize() {
        return this._size;
    }

    @Override
    public Date getLastIndexingEndTime() {
        return new Date(this._endTime);
    }

    @Override
    public void resetAverage() {
        this._totalSize = 0;
        this._totalTime = 0L;
    }

    @Override
    public void handleIndexingEvent(IndexingEventListener.IndexingEvent evt) {
        if (evt instanceof IndexUpdatedEvent) {
            IndexUpdatedEvent updateEvt = (IndexUpdatedEvent)evt;
            this._startTime = updateEvt.getStartIndexingTime();
            this._endTime = updateEvt.getEndIndexingTime();
            this._leftOver = updateEvt.getNumDocsLeftInQueue();
            this._size = updateEvt.getNumDocsIndexed();
            this._totalSize += this._size;
            this._totalTime += this._endTime - this._startTime;
        }
    }

    @Override
    public void handleUpdatedDiskVersion(String version) {
        this._diskVersion = version;
    }

    @Override
    public String getCurrentDiskVersion() {
        return this._diskVersion;
    }
}

