/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.pair.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import proj.zoie.api.DataConsumer;
import proj.zoie.api.DefaultDirectoryManager;
import proj.zoie.api.DirectoryManager;
import proj.zoie.api.IndexCopier;
import proj.zoie.api.Zoie;
import proj.zoie.api.ZoieException;
import proj.zoie.api.ZoieHealth;
import proj.zoie.api.ZoieIndexReader;
import proj.zoie.api.indexing.IndexReaderDecorator;
import proj.zoie.api.indexing.ZoieIndexableInterpreter;
import proj.zoie.impl.indexing.ZoieConfig;
import proj.zoie.impl.indexing.ZoieSystem;
import proj.zoie.impl.indexing.internal.IndexSignature;
import proj.zoie.mbean.ZoieAdminMBean;

public class Pair<R extends IndexReader, D>
implements Zoie<R, D> {
    public static final Logger log = Logger.getLogger(Pair.class);
    private static final String COMMIT_FILE = "committed";
    private volatile boolean _running = false;
    private volatile Zoie<R, D> _zoieOne;
    private final Zoie<R, D> _zoieTwo;
    private final File _zoieOneRoot;
    private final IndexCopier _indexCopier;
    private final ZoieIndexableInterpreter<D> _interpreter;
    private final IndexReaderDecorator<R> _decorator;
    private final ZoieConfig _zoieConfig;
    private final DirectoryManager.DIRECTORY_MODE _dirMode;
    private Map<IndexReader, ZoieRef> _activeReaders;
    public static String PAIRADMIN = "pair-admin";

    public Pair(File zoieOneRoot, DirectoryManager.DIRECTORY_MODE dirMode, IndexCopier indexCopier, ZoieIndexableInterpreter<D> interpreter, IndexReaderDecorator<R> decorator, ZoieConfig zoieConfig, Zoie<R, D> zoieTwo) {
        this._zoieOneRoot = zoieOneRoot;
        this._indexCopier = indexCopier;
        this._interpreter = interpreter;
        this._decorator = decorator;
        this._zoieConfig = zoieConfig;
        this._zoieTwo = zoieTwo;
        this._dirMode = dirMode;
        this._activeReaders = new HashMap<IndexReader, ZoieRef>();
        if (this._zoieOneRoot == null) {
            throw new IllegalArgumentException("zoieOneRoot cannot be null.");
        }
        if (this._zoieOneRoot.exists()) {
            Object[] files = this._zoieOneRoot.listFiles();
            Arrays.sort(files);
            for (int i = files.length - 1; i >= 0; --i) {
                if (!new File((File)files[i], COMMIT_FILE).exists()) continue;
                log.info((Object)("Found latest zoieOne index: " + ((File)files[i]).getAbsolutePath()));
                DefaultDirectoryManager dirMgr = new DefaultDirectoryManager((File)files[i], dirMode);
                this._zoieOne = new ZoieSystem<R, D>(dirMgr, this._interpreter, this._decorator, this._zoieConfig);
                break;
            }
        }
    }

    public synchronized boolean loadIndex(String src) {
        File dest = new File(this._zoieOneRoot, String.valueOf(System.currentTimeMillis()));
        while (!dest.mkdirs()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            dest = new File(this._zoieOneRoot, String.valueOf(System.currentTimeMillis()));
        }
        log.info((Object)("Copying " + src + " to " + dest.getAbsolutePath()));
        if (!this._indexCopier.copy(src, dest.getAbsolutePath())) {
            return false;
        }
        File directoryFile = new File(dest, "index.directory");
        if (!directoryFile.exists()) {
            log.warn((Object)"index directory file not exists, creating a empty one.");
            IndexSignature sig = new IndexSignature(null);
            try {
                DefaultDirectoryManager.saveSignature(sig, directoryFile);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return false;
            }
        }
        try {
            FileOutputStream out = new FileOutputStream(new File(dest, COMMIT_FILE));
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        DefaultDirectoryManager dirMgr = new DefaultDirectoryManager(dest, DirectoryManager.DIRECTORY_MODE.MMAP);
        ZoieSystem<R, D> zoie = new ZoieSystem<R, D>(dirMgr, this._interpreter, this._decorator, this._zoieConfig);
        if (this._running) {
            zoie.start();
        }
        if (this._zoieOne != null) {
            final Zoie<R, D> toBeShutdown = this._zoieOne;
            this._zoieOne = zoie;
            Timer cleanupTimer = new Timer();
            cleanupTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = Pair.this._activeReaders;
                    synchronized (map) {
                        for (ZoieRef z : Pair.this._activeReaders.values()) {
                            if (z.zoie != toBeShutdown) continue;
                            log.info((Object)"Waiting for active readers...");
                            return;
                        }
                    }
                    log.info((Object)"Shuting down old zoie...");
                    toBeShutdown.shutdown();
                    this.cancel();
                }
            }, 8000L, 8000L);
        }
        this._zoieOne = zoie;
        return true;
    }

    @Override
    public void start() {
        this._running = true;
        Zoie<R, D> zoieOne = this._zoieOne;
        if (zoieOne != null) {
            zoieOne.start();
        }
        if (this._zoieTwo != null) {
            this._zoieTwo.start();
        }
    }

    @Override
    public void shutdown() {
        this._running = false;
        Zoie<R, D> zoieOne = this._zoieOne;
        if (zoieOne != null) {
            zoieOne.shutdown();
        }
        if (this._zoieTwo != null) {
            this._zoieTwo.shutdown();
        }
    }

    @Override
    public StandardMBean getStandardMBean(String name) {
        if (name.equals(PAIRADMIN)) {
            try {
                return new StandardMBean(this.getAdminMBean(), PairAdminMBean.class);
            }
            catch (NotCompliantMBeanException e) {
                log.info((Object)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public PairAdminMBean getAdminMBean() {
        return new MyPairAdmin();
    }

    @Override
    public String[] getStandardMBeanNames() {
        return new String[]{PAIRADMIN};
    }

    @Override
    public void syncWithVersion(long timeInMillis, String version) throws ZoieException {
        if (this._zoieTwo != null) {
            this._zoieTwo.syncWithVersion(timeInMillis, version);
        }
    }

    @Override
    public void flushEvents(long timeout) throws ZoieException {
        if (this._zoieTwo != null) {
            this._zoieTwo.flushEvents(timeout);
        }
    }

    @Override
    public void consume(Collection<DataConsumer.DataEvent<D>> data) throws ZoieException {
        if (this._zoieTwo != null) {
            this._zoieTwo.consume(data);
        }
    }

    @Override
    public String getVersion() {
        String v1 = null;
        String v2 = null;
        Zoie<R, D> zoieOne = this._zoieOne;
        if (zoieOne != null) {
            v1 = zoieOne.getVersion();
        }
        if (this._zoieTwo != null) {
            v2 = this._zoieTwo.getVersion();
        }
        return this._zoieConfig.getVersionComparator().compare(v2, v1) > 0 ? v2 : v1;
    }

    @Override
    public String getCurrentReaderVersion() {
        String v1 = null;
        String v2 = null;
        Zoie<R, D> zoieOne = this._zoieOne;
        if (zoieOne != null) {
            v1 = zoieOne.getCurrentReaderVersion();
        }
        if (this._zoieTwo != null) {
            v2 = this._zoieTwo.getCurrentReaderVersion();
        }
        return this._zoieConfig.getVersionComparator().compare(v2, v1) > 0 ? v2 : v1;
    }

    @Override
    public Comparator<String> getVersionComparator() {
        return this._zoieConfig.getVersionComparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ZoieIndexReader<R>> getIndexReaders() throws IOException {
        Zoie<R, D> zoieOne;
        ArrayList<ZoieIndexReader<R>> readers = new ArrayList<ZoieIndexReader<R>>();
        if (this._zoieTwo != null) {
            readers.addAll(this._zoieTwo.getIndexReaders());
        }
        if ((zoieOne = this._zoieOne) != null) {
            List r1 = zoieOne.getIndexReaders();
            for (ZoieIndexReader r : r1) {
                Map<IndexReader, ZoieRef> map = this._activeReaders;
                synchronized (map) {
                    ZoieRef zoieRef = this._activeReaders.get((Object)r);
                    if (zoieRef != null) {
                        ++zoieRef.refCount;
                    } else {
                        zoieRef = new ZoieRef(zoieOne);
                        this._activeReaders.put((IndexReader)r, zoieRef);
                    }
                }
            }
            readers.addAll(r1);
        }
        return readers;
    }

    @Override
    public Analyzer getAnalyzer() {
        return this._zoieConfig.getAnalyzer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnIndexReaders(List<ZoieIndexReader<R>> readers) {
        if (readers != null) {
            HashMap<Zoie<R, D>, ArrayList<ZoieIndexReader<R>>> destMap = new HashMap<Zoie<R, D>, ArrayList<ZoieIndexReader<R>>>();
            for (ZoieIndexReader<R> zoieIndexReader : readers) {
                Zoie<Object, Object> zoie = this._zoieTwo;
                Map<IndexReader, ZoieRef> map = this._activeReaders;
                synchronized (map) {
                    ZoieRef zoieRef = this._activeReaders.get(zoieIndexReader);
                    if (zoieRef != null) {
                        zoie = zoieRef.zoie;
                        --zoieRef.refCount;
                        if (zoieRef.refCount <= 0) {
                            this._activeReaders.remove(zoieIndexReader);
                        }
                    }
                }
                ArrayList<ZoieIndexReader<R>> readerList = (ArrayList<ZoieIndexReader<R>>)destMap.get(zoie);
                if (readerList == null) {
                    readerList = new ArrayList<ZoieIndexReader<R>>();
                    destMap.put(zoie, readerList);
                }
                readerList.add(zoieIndexReader);
            }
            for (Map.Entry entry : destMap.entrySet()) {
                ((Zoie)entry.getKey()).returnIndexReaders((List)entry.getValue());
            }
        }
    }

    private static class ZoieRef {
        public Zoie<?, ?> zoie;
        public int refCount;

        public ZoieRef(Zoie<?, ?> zoie) {
            this.zoie = zoie;
        }
    }

    private class MyPairAdmin
    implements PairAdminMBean {
        private MyPairAdmin() {
        }

        @Override
        public boolean loadIndex(String src) {
            return Pair.this.loadIndex(src);
        }

        @Override
        public String getIndexDir() {
            return Pair.this._zoieOneRoot.getAbsolutePath();
        }

        @Override
        public boolean isRealtime() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().isRealtime();
            }
            return false;
        }

        @Override
        public long getBatchDelay() {
            return Pair.this._zoieConfig.getBatchDelay();
        }

        @Override
        public void setBatchDelay(long delay) {
            Pair.this._zoieConfig.setBatchDelay(delay);
            if (Pair.this._zoieOne != null) {
                Pair.this._zoieOne.getAdminMBean().setBatchDelay(delay);
            }
            if (Pair.this._zoieTwo != null) {
                Pair.this._zoieTwo.getAdminMBean().setBatchDelay(delay);
            }
        }

        @Override
        public int getBatchSize() {
            return Pair.this._zoieConfig.getBatchSize();
        }

        @Override
        public void setBatchSize(int batchSize) {
            Pair.this._zoieConfig.setBatchSize(batchSize);
            if (Pair.this._zoieOne != null) {
                Pair.this._zoieOne.getAdminMBean().setBatchSize(batchSize);
            }
            if (Pair.this._zoieTwo != null) {
                Pair.this._zoieTwo.getAdminMBean().setBatchSize(batchSize);
            }
        }

        @Override
        public Date getLastDiskIndexModifiedTime() {
            Date d1 = null;
            Date d2 = null;
            if (Pair.this._zoieTwo != null) {
                d2 = Pair.this._zoieTwo.getAdminMBean().getLastDiskIndexModifiedTime();
            }
            d1 = Pair.this._zoieOne.getAdminMBean().getLastDiskIndexModifiedTime();
            if (d2 == null) {
                return d1;
            }
            if (d1 == null) {
                return d2;
            }
            if (d1.compareTo(d2) > 0) {
                return d1;
            }
            return d2;
        }

        @Override
        public int getMaxBatchSize() {
            return Pair.this._zoieConfig.getMaxBatchSize();
        }

        @Override
        public void setMaxBatchSize(int maxBatchSize) {
            Pair.this._zoieConfig.setMaxBatchSize(maxBatchSize);
            if (Pair.this._zoieOne != null) {
                Pair.this._zoieOne.getAdminMBean().setMaxBatchSize(maxBatchSize);
            }
            if (Pair.this._zoieTwo != null) {
                Pair.this._zoieTwo.getAdminMBean().setMaxBatchSize(maxBatchSize);
            }
        }

        @Override
        public void setMergeFactor(int mergeFactor) {
            if (Pair.this._zoieOne != null) {
                Pair.this._zoieOne.getAdminMBean().setMergeFactor(mergeFactor);
            }
            if (Pair.this._zoieTwo != null) {
                Pair.this._zoieTwo.getAdminMBean().setMergeFactor(mergeFactor);
            }
        }

        @Override
        public int getMergeFactor() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getMergeFactor();
            }
            return Pair.this._zoieOne.getAdminMBean().getMergeFactor();
        }

        @Override
        public int getRamAIndexSize() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getRamAIndexSize();
            }
            return 0;
        }

        @Override
        public String getRamAVersion() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getRamAVersion();
            }
            return null;
        }

        @Override
        public int getRamBIndexSize() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getRamBIndexSize();
            }
            return 0;
        }

        @Override
        public String getRamBVersion() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getRamBVersion();
            }
            return null;
        }

        @Override
        public String getDiskIndexerStatus() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getDiskIndexerStatus();
            }
            return Pair.this._zoieOne.getAdminMBean().getDiskIndexerStatus();
        }

        @Override
        public String getCurrentDiskVersion() throws IOException {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getCurrentDiskVersion();
            }
            return Pair.this._zoieOne.getAdminMBean().getCurrentDiskVersion();
        }

        @Override
        public void refreshDiskReader() throws IOException {
            if (Pair.this._zoieTwo != null) {
                Pair.this._zoieTwo.getAdminMBean().refreshDiskReader();
            }
            if (Pair.this._zoieOne != null) {
                Pair.this._zoieOne.getAdminMBean().refreshDiskReader();
            }
        }

        @Override
        public void flushToDiskIndex() throws ZoieException {
            if (Pair.this._zoieTwo != null) {
                Pair.this._zoieTwo.getAdminMBean().flushToDiskIndex();
            }
            if (Pair.this._zoieOne != null) {
                Pair.this._zoieOne.getAdminMBean().flushToDiskIndex();
            }
        }

        @Override
        public void flushToMemoryIndex() throws ZoieException {
            if (Pair.this._zoieTwo != null) {
                Pair.this._zoieTwo.getAdminMBean().flushToMemoryIndex();
            }
            if (Pair.this._zoieOne != null) {
                Pair.this._zoieOne.getAdminMBean().flushToMemoryIndex();
            }
        }

        @Override
        public int getMaxMergeDocs() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getMaxMergeDocs();
            }
            return Pair.this._zoieOne.getAdminMBean().getMaxMergeDocs();
        }

        @Override
        public void setMaxMergeDocs(int maxMergeDocs) {
            if (Pair.this._zoieTwo != null) {
                Pair.this._zoieTwo.getAdminMBean().setMaxMergeDocs(maxMergeDocs);
            }
            if (Pair.this._zoieOne != null) {
                Pair.this._zoieOne.getAdminMBean().setMaxMergeDocs(maxMergeDocs);
            }
        }

        @Override
        public void setNumLargeSegments(int numLargeSegments) {
            if (Pair.this._zoieTwo != null) {
                Pair.this._zoieTwo.getAdminMBean().setNumLargeSegments(numLargeSegments);
            }
            if (Pair.this._zoieOne != null) {
                Pair.this._zoieOne.getAdminMBean().setNumLargeSegments(numLargeSegments);
            }
        }

        @Override
        public int getNumLargeSegments() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getNumLargeSegments();
            }
            return Pair.this._zoieOne.getAdminMBean().getNumLargeSegments();
        }

        @Override
        public void setMaxSmallSegments(int maxSmallSegments) {
            if (Pair.this._zoieTwo != null) {
                Pair.this._zoieTwo.getAdminMBean().setMaxSmallSegments(maxSmallSegments);
            }
            if (Pair.this._zoieOne != null) {
                Pair.this._zoieOne.getAdminMBean().setMaxSmallSegments(maxSmallSegments);
            }
        }

        @Override
        public int getMaxSmallSegments() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getMaxSmallSegments();
            }
            return Pair.this._zoieOne.getAdminMBean().getMaxSmallSegments();
        }

        @Override
        public long getDiskIndexSizeBytes() {
            long size = 0L;
            if (Pair.this._zoieTwo != null) {
                size = Pair.this._zoieTwo.getAdminMBean().getDiskIndexSizeBytes();
            }
            if (Pair.this._zoieOne != null) {
                size += Pair.this._zoieTwo.getAdminMBean().getDiskIndexSizeBytes();
            }
            return size;
        }

        @Override
        public long getDiskFreeSpaceBytes() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getDiskFreeSpaceBytes();
            }
            return Pair.this._zoieOne.getAdminMBean().getDiskFreeSpaceBytes();
        }

        @Override
        public boolean isUseCompoundFile() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().isUseCompoundFile();
            }
            return Pair.this._zoieOne.getAdminMBean().isUseCompoundFile();
        }

        @Override
        public int getDiskIndexSegmentCount() throws IOException {
            int count = 0;
            if (Pair.this._zoieTwo != null) {
                count = Pair.this._zoieTwo.getAdminMBean().getDiskIndexSegmentCount();
            }
            if (Pair.this._zoieOne != null) {
                count += Pair.this._zoieTwo.getAdminMBean().getDiskIndexSegmentCount();
            }
            return count;
        }

        @Override
        public int getRAMASegmentCount() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getRAMASegmentCount();
            }
            return 0;
        }

        @Override
        public int getRAMBSegmentCount() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getRAMBSegmentCount();
            }
            return 0;
        }

        @Override
        public long getSLA() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getSLA();
            }
            return Pair.this._zoieOne.getAdminMBean().getSLA();
        }

        @Override
        public void setSLA(long sla) {
            if (Pair.this._zoieTwo != null) {
                Pair.this._zoieTwo.getAdminMBean().setSLA(sla);
            }
            if (Pair.this._zoieOne != null) {
                Pair.this._zoieOne.getAdminMBean().setSLA(sla);
            }
        }

        @Override
        public long getHealth() {
            return ZoieHealth.getHealth();
        }

        @Override
        public void resetHealth() {
            ZoieHealth.setOK();
        }

        @Override
        public int getCurrentMemBatchSize() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getCurrentMemBatchSize();
            }
            return 0;
        }

        @Override
        public int getCurrentDiskBatchSize() {
            if (Pair.this._zoieTwo != null) {
                return Pair.this._zoieTwo.getAdminMBean().getCurrentDiskBatchSize();
            }
            return Pair.this._zoieOne.getAdminMBean().getCurrentDiskBatchSize();
        }
    }

    public static interface PairAdminMBean
    extends ZoieAdminMBean {
        public boolean loadIndex(String var1);
    }
}

