/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.store;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import proj.zoie.impl.indexing.ZoieConfig;
import proj.zoie.store.ZoieStore;

public abstract class AbstractZoieStore
implements ZoieStore {
    private static Logger logger = Logger.getLogger(AbstractZoieStore.class);
    private boolean _dataCompressed = true;
    private Comparator<String> _versionComparator = ZoieConfig.DEFAULT_VERSION_COMPARATOR;
    private volatile String _version = null;
    private final Long2ObjectLinkedOpenHashMap<byte[]> _dataMap = new Long2ObjectLinkedOpenHashMap();
    private final ReentrantReadWriteLock _dataMapLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock _writeLock = this._dataMapLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock _readLock = this._dataMapLock.readLock();

    public void setVersionComparator(Comparator<String> versionComparator) {
        this._versionComparator = versionComparator;
    }

    public Comparator<String> getVersionComparator() {
        return this._versionComparator;
    }

    public void setDataCompressed(boolean dataCompressed) {
        this._dataCompressed = dataCompressed;
    }

    public boolean isDataCompressed() {
        return this._dataCompressed;
    }

    protected abstract void persist(long var1, byte[] var3) throws IOException;

    protected abstract void persistDelete(long var1) throws IOException;

    protected abstract byte[] getFromStore(long var1) throws IOException;

    protected abstract void commitVersion(String var1) throws IOException;

    @Override
    public abstract String getPersistedVersion() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract void open() throws IOException;

    public static byte[] compress(byte[] src) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GZIPOutputStream gzipStream = new GZIPOutputStream(bout);
        gzipStream.write(src);
        gzipStream.flush();
        gzipStream.close();
        bout.flush();
        return bout.toByteArray();
    }

    public static byte[] uncompress(byte[] src) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        ByteArrayInputStream bin = new ByteArrayInputStream(src);
        GZIPInputStream gzipIn = new GZIPInputStream(bin);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while (gzipIn.available() > 0 && (len = gzipIn.read(buffer)) > 0) {
            if (len < buffer.length) {
                bout.write(buffer, 0, len);
                continue;
            }
            bout.write(buffer);
        }
        bout.flush();
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOException {
        this._writeLock.lock();
        try {
            this.commitVersion(this._version);
            this._dataMap.clear();
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(long uid, String version) throws IOException {
        this._writeLock.lock();
        try {
            this.persistDelete(uid);
            this._dataMap.remove(uid);
            this._version = version;
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(long uid, byte[] data, String version) throws IOException {
        if (this._dataCompressed) {
            data = AbstractZoieStore.compress(data);
        }
        this._writeLock.lock();
        try {
            this.persist(uid, data);
            this._dataMap.put(uid, (Object)data);
            this._version = version;
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] innerGet(long uid) throws IOException {
        byte[] data = null;
        try {
            this._readLock.lock();
            data = (byte[])this._dataMap.get(uid);
        }
        finally {
            this._readLock.unlock();
        }
        if (data == null) {
            data = this.getFromStore(uid);
        }
        if (data != null && this._dataCompressed) {
            data = AbstractZoieStore.uncompress(data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] get(long uid) throws IOException {
        this._readLock.lock();
        try {
            byte[] byArray = this.innerGet(uid);
            return byArray;
        }
        finally {
            this._readLock.unlock();
        }
    }

    @Override
    public final String getVersion() {
        return this._version;
    }

    @Override
    public byte[][] get(long[] uids) {
        byte[][] dataList = new byte[uids.length][];
        int idx = 0;
        for (long uid : uids) {
            try {
                dataList[idx++] = this.innerGet(uid);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return dataList;
    }
}

