/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.store;

import it.unimi.dsi.fastutil.longs.Long2IntRBTreeMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import proj.zoie.api.ZoieSegmentReader;
import proj.zoie.api.impl.ZoieMergePolicy;
import proj.zoie.store.AbstractZoieStore;
import proj.zoie.store.ZoieStore;

public class LuceneStore
extends AbstractZoieStore {
    private static final String VERSION_NAME = "version";
    private static final Logger logger = Logger.getLogger(LuceneStore.class);
    private final String _field;
    private final Directory _dir;
    private IndexWriter _idxWriter;
    private volatile ReaderData _currentReaderData;
    private volatile ReaderData _oldReaderData;
    private volatile boolean _closed = true;

    private LuceneStore(Directory dir, String field) throws IOException {
        this._field = field;
        this._idxWriter = null;
        this._dir = dir;
    }

    @Override
    public void open() throws IOException {
        if (this._closed) {
            IndexWriterConfig idxWriterConfig = new IndexWriterConfig(Version.LUCENE_34, (Analyzer)new StandardAnalyzer(Version.LUCENE_34));
            idxWriterConfig.setMergePolicy((MergePolicy)new ZoieMergePolicy());
            idxWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            this._idxWriter = new IndexWriter(this._dir, idxWriterConfig);
            this.updateReader();
            this._closed = false;
        }
    }

    private void updateReader() throws IOException {
        ReaderData readerData;
        IndexReader idxReader;
        IndexReader oldReader = null;
        if (this._currentReaderData != null) {
            oldReader = this._currentReaderData.reader;
        }
        if ((idxReader = IndexReader.open((IndexWriter)this._idxWriter, (boolean)true)) == oldReader) {
            return;
        }
        this._currentReaderData = readerData = new ReaderData(idxReader);
        if (this._oldReaderData != null) {
            ReaderData tmpOld = this._oldReaderData;
            this._oldReaderData = this._currentReaderData;
            tmpOld.close();
        }
        this._currentReaderData = readerData;
    }

    public static ZoieStore openStore(Directory idxDir, String field, boolean compressionOff) throws IOException {
        LuceneStore store = new LuceneStore(idxDir, field);
        store.setDataCompressed(!compressionOff);
        store.open();
        return store;
    }

    private int mapDocId(long uid) {
        if (this._currentReaderData != null && this._currentReaderData._maxUID >= uid && this._currentReaderData._minUID <= uid) {
            return this._currentReaderData.uidMap.get(uid);
        }
        return -1;
    }

    @Override
    protected void persist(long uid, byte[] data) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field(this._field, data));
        ZoieSegmentReader.fillDocumentID(doc, uid);
        this._idxWriter.addDocument(doc);
    }

    @Override
    protected void persistDelete(long uid) throws IOException {
        final int docid = this.mapDocId(uid);
        if (docid < 0) {
            return;
        }
        ConstantScoreQuery deleteQ = new ConstantScoreQuery(new Filter(){
            private static final long serialVersionUID = 1L;

            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                return new DocIdSet(){

                    public DocIdSetIterator iterator() throws IOException {
                        return new DocIdSetIterator(){
                            int currId = -1;

                            public int nextDoc() throws IOException {
                                this.currId = this.currId == -1 ? docid : Integer.MAX_VALUE;
                                return this.currId;
                            }

                            public int docID() {
                                return this.currId;
                            }

                            public int advance(int target) throws IOException {
                                if (this.currId != Integer.MAX_VALUE) {
                                    this.currId = target < docid ? docid : Integer.MAX_VALUE;
                                }
                                return this.currId;
                            }
                        };
                    }
                };
            }
        });
        this._idxWriter.deleteDocuments((Query)deleteQ);
        if (this._currentReaderData != null) {
            this._currentReaderData.uidMap.remove(uid);
        }
    }

    @Override
    protected byte[] getFromStore(long uid) throws IOException {
        Document doc;
        int docid = this.mapDocId(uid);
        if (docid < 0) {
            return null;
        }
        IndexReader reader = null;
        if (this._currentReaderData != null) {
            reader = this._currentReaderData.reader;
        }
        if (docid >= 0 && reader != null && (doc = reader.document(docid)) != null) {
            return doc.getBinaryValue(this._field);
        }
        return null;
    }

    @Override
    protected void commitVersion(String version) throws IOException {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        versionMap.put(VERSION_NAME, version);
        this._idxWriter.commit(versionMap);
        this.updateReader();
    }

    @Override
    public String getPersistedVersion() throws IOException {
        IndexReader reader = null;
        if (this._currentReaderData != null) {
            reader = this._currentReaderData.reader;
        }
        if (reader != null) {
            Map versionMap = reader.getCommitUserData();
            return (String)versionMap.get(VERSION_NAME);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._idxWriter.close();
            this._closed = true;
        }
    }

    private static class ReaderData {
        final IndexReader reader;
        final Long2IntRBTreeMap uidMap;
        final long _minUID;
        final long _maxUID;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ReaderData(IndexReader reader) throws IOException {
            this.reader = reader;
            long minUID = Long.MAX_VALUE;
            long maxUID = Long.MIN_VALUE;
            this.uidMap = new Long2IntRBTreeMap();
            this.uidMap.defaultReturnValue(-1);
            int maxDoc = reader.maxDoc();
            if (maxDoc == 0) {
                this._minUID = Long.MIN_VALUE;
                this._maxUID = Long.MIN_VALUE;
                return;
            }
            TermPositions tp = null;
            byte[] payloadBuffer = new byte[8];
            try {
                tp = reader.termPositions(ZoieSegmentReader.UID_TERM);
                while (tp.next()) {
                    int doc = tp.doc();
                    assert (doc < maxDoc);
                    tp.nextPosition();
                    tp.getPayload(payloadBuffer, 0);
                    long uid = ZoieSegmentReader.bytesToLong(payloadBuffer);
                    if (uid < minUID) {
                        minUID = uid;
                    }
                    if (uid > maxUID) {
                        maxUID = uid;
                    }
                    this.uidMap.put(uid, doc);
                }
            }
            finally {
                if (tp != null) {
                    tp.close();
                }
            }
            this._minUID = minUID;
            this._maxUID = maxUID;
        }

        void close() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

