/*
 * Decompiled with CFR 0.152.
 */
package proj.zoie.store;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import org.apache.log4j.Logger;
import proj.zoie.api.DataConsumer;
import proj.zoie.api.LifeCycleCotrolledDataConsumer;
import proj.zoie.api.ZoieException;
import proj.zoie.store.ZoieStore;
import proj.zoie.store.ZoieStoreSerializer;

public class ZoieStoreConsumer<D>
implements LifeCycleCotrolledDataConsumer<D> {
    private static final Logger logger = Logger.getLogger(ZoieStoreConsumer.class);
    private final ZoieStore _store;
    private final ZoieStoreSerializer<D> _serializer;

    public ZoieStoreConsumer(ZoieStore store, ZoieStoreSerializer<D> serializer) {
        this._store = store;
        this._serializer = serializer;
    }

    @Override
    public void consume(Collection<DataConsumer.DataEvent<D>> data) throws ZoieException {
        for (DataConsumer.DataEvent<D> datum : data) {
            String version = datum.getVersion();
            D obj = datum.getData();
            try {
                byte[] bytes = this._serializer.toBytes(obj);
                long id = this._serializer.getUid(obj);
                this._store.put(id, bytes, version);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void flushEvents() throws ZoieException {
        try {
            this._store.commit();
        }
        catch (Exception e) {
            throw new ZoieException(e.getMessage(), e);
        }
    }

    @Override
    public String getVersion() {
        return this._store.getVersion();
    }

    @Override
    public Comparator<String> getVersionComparator() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public void start() {
        try {
            this._store.open();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            this._store.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

