/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.focus.channel.push;

import com.sensorsdata.focus.channel.entry.MessagingTask;
import com.sensorsdata.focus.channel.entry.PushTask;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PushTaskUtils {
    private static final Logger log = LoggerFactory.getLogger(PushTaskUtils.class);
    private static final String SF_DATA_PLACEHOLDER = "{sf_data}";
    private static final String SF_CUSTOMIZED_PLACEHOLDER = "{sf_customized}";
    private static final String SF_CUSTOMIZED_PLACEHOLDER_WITH_END_SEMICOLON = "{sf_customized};";

    private static String generateTaskKey(PushTask pushTask) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("title='").append(pushTask.getMsgTitle()).append('\'');
        stringBuilder.append(", text='").append(pushTask.getMsgContent()).append('\'');
        stringBuilder.append(", landingType=").append((Object)pushTask.getLandingType());
        stringBuilder.append(", linkUrl='").append(pushTask.getLinkUrl()).append('\'');
        stringBuilder.append(", customized='").append(pushTask.getCustomized()).append('\'');
        return stringBuilder.toString();
    }

    private static Collection<List<MessagingTask>> groupByTaskContent(List<MessagingTask> messagingTasks) {
        LinkedHashMap<String, List> groupByNode = new LinkedHashMap<String, List>();
        for (MessagingTask task : messagingTasks) {
            String key = PushTaskUtils.generateTaskKey(task.getPushTask());
            List sameContentTaskList = groupByNode.computeIfAbsent(key, k -> new ArrayList());
            sameContentTaskList.add(task);
        }
        return groupByNode.values();
    }

    public static Collection<List<MessagingTask>> groupByTaskContent(List<MessagingTask> messagingTasks, int batchSize) {
        Collection<List<MessagingTask>> groupByCollection = PushTaskUtils.groupByTaskContent(messagingTasks);
        ArrayList<List<MessagingTask>> result = new ArrayList<List<MessagingTask>>();
        for (List<MessagingTask> oneGroup : groupByCollection) {
            if (oneGroup.size() < batchSize) {
                result.add(oneGroup);
                continue;
            }
            for (int i = 0; i < oneGroup.size(); i += batchSize) {
                result.add(oneGroup.subList(i, Math.min(i + batchSize, oneGroup.size())));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static String generateIntentFromTemplate(PushTask pushTask, String intentTemplate) {
        int customizedIndex;
        String encodedSfData;
        try {
            encodedSfData = URLEncoder.encode(pushTask.getSfData(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("can't do url encode. [sf_data='{}']", (Object)pushTask.getSfData());
            throw new RuntimeException(e);
        }
        String intent = StringUtils.replace((String)intentTemplate, (String)SF_DATA_PLACEHOLDER, (String)encodedSfData);
        if (pushTask.getCustomized() != null) {
            for (Map.Entry<String, String> customPair : pushTask.getCustomized().entrySet()) {
                String key = String.format("{sf_customized.%s}", customPair.getKey());
                intent = StringUtils.replace((String)intent, (String)key, (String)customPair.getValue());
            }
        }
        if ((customizedIndex = intent.indexOf(SF_CUSTOMIZED_PLACEHOLDER)) >= 0) {
            void var7_13;
            StringBuilder paramBuilder = new StringBuilder();
            if (pushTask.getCustomized() != null) {
                for (Map.Entry entry : pushTask.getCustomized().entrySet()) {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)entry.getKey()))) continue;
                    paramBuilder.append(String.format("S.%s=%s;", entry.getKey(), entry.getValue()));
                }
            }
            int placeHolderEndIndex = SF_CUSTOMIZED_PLACEHOLDER.length() + customizedIndex;
            String string = SF_CUSTOMIZED_PLACEHOLDER;
            if (placeHolderEndIndex < intent.length() && intent.charAt(placeHolderEndIndex) == ';') {
                String string2 = SF_CUSTOMIZED_PLACEHOLDER_WITH_END_SEMICOLON;
            }
            intent = StringUtils.replace((String)intent, (String)var7_13, (String)paramBuilder.toString());
        }
        return intent;
    }

    private PushTaskUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

