/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.webhook;

import com.sensorsdata.webhook.middleman.SfWebhookAsyncMiddleManServlet;
import com.sensorsdata.webhook.middleman.SfWebhookMiddleManProcessor;
import com.sensorsdata.webhook.processor.SfWebhookProcessor;
import com.sensorsdata.webhook.processor.SfWebhookServlet;
import com.sensorsdata.webhook.server.EndpointServer;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServlet;
import shaded.sf.org.apache.commons.lang3.StringUtils;

public class Bootstrap {
    int localPort;
    SfWebhookMiddleManProcessor middleManProcessor;
    SfWebhookProcessor webhookProcessor;
    String secretTokenForSignatureCheck;
    int serverThreadPoolMaxSize;

    public EndpointServer startServer() throws Exception {
        if (this.webhookProcessor != null && this.middleManProcessor != null) {
            throw new Exception("can have only one of SfWebhookProcessor & SfWebhookMiddleManProcessor");
        }
        byte[] secretTokenBytes = null;
        if (StringUtils.isNotBlank(this.secretTokenForSignatureCheck)) {
            secretTokenBytes = this.secretTokenForSignatureCheck.getBytes(StandardCharsets.UTF_8);
        }
        HttpServlet httpServlet = this.webhookProcessor != null ? new SfWebhookServlet(this.webhookProcessor, secretTokenBytes) : new SfWebhookAsyncMiddleManServlet(this.middleManProcessor, secretTokenBytes);
        this.serverThreadPoolMaxSize = Math.max(8, this.serverThreadPoolMaxSize);
        EndpointServer endpointServer = new EndpointServer();
        endpointServer.startServer(this.localPort, httpServlet, this.serverThreadPoolMaxSize);
        return endpointServer;
    }

    Bootstrap(int localPort, SfWebhookMiddleManProcessor middleManProcessor, SfWebhookProcessor webhookProcessor, String secretTokenForSignatureCheck, int serverThreadPoolMaxSize) {
        this.localPort = localPort;
        this.middleManProcessor = middleManProcessor;
        this.webhookProcessor = webhookProcessor;
        this.secretTokenForSignatureCheck = secretTokenForSignatureCheck;
        this.serverThreadPoolMaxSize = serverThreadPoolMaxSize;
    }

    public static BootstrapBuilder builder() {
        return new BootstrapBuilder();
    }

    public static class BootstrapBuilder {
        private int localPort;
        private SfWebhookMiddleManProcessor middleManProcessor;
        private SfWebhookProcessor webhookProcessor;
        private String secretTokenForSignatureCheck;
        private int serverThreadPoolMaxSize;

        BootstrapBuilder() {
        }

        public BootstrapBuilder localPort(int localPort) {
            this.localPort = localPort;
            return this;
        }

        public BootstrapBuilder middleManProcessor(SfWebhookMiddleManProcessor middleManProcessor) {
            this.middleManProcessor = middleManProcessor;
            return this;
        }

        public BootstrapBuilder webhookProcessor(SfWebhookProcessor webhookProcessor) {
            this.webhookProcessor = webhookProcessor;
            return this;
        }

        public BootstrapBuilder secretTokenForSignatureCheck(String secretTokenForSignatureCheck) {
            this.secretTokenForSignatureCheck = secretTokenForSignatureCheck;
            return this;
        }

        public BootstrapBuilder serverThreadPoolMaxSize(int serverThreadPoolMaxSize) {
            this.serverThreadPoolMaxSize = serverThreadPoolMaxSize;
            return this;
        }

        public Bootstrap build() {
            return new Bootstrap(this.localPort, this.middleManProcessor, this.webhookProcessor, this.secretTokenForSignatureCheck, this.serverThreadPoolMaxSize);
        }

        public String toString() {
            return "Bootstrap.BootstrapBuilder(localPort=" + this.localPort + ", middleManProcessor=" + this.middleManProcessor + ", webhookProcessor=" + this.webhookProcessor + ", secretTokenForSignatureCheck=" + this.secretTokenForSignatureCheck + ", serverThreadPoolMaxSize=" + this.serverThreadPoolMaxSize + ")";
        }
    }
}

