/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.webhook.common;

import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.sf.com.fasterxml.jackson.databind.DeserializationFeature;
import shaded.sf.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.sf.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import shaded.sf.org.apache.commons.codec.binary.Base64;
import shaded.sf.org.apache.commons.codec.digest.HmacUtils;
import shaded.sf.org.apache.commons.lang3.StringUtils;

public final class SfUtils {
    private static final Logger log = LoggerFactory.getLogger(SfUtils.class);
    public static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();

    public static boolean checkSignature(HttpServletRequest request, byte[] requestBodyBytes, byte[] secretToken) {
        if (secretToken == null) {
            return true;
        }
        String signatureHeader = request.getHeader("X-Sf-Signature");
        if (StringUtils.isBlank(signatureHeader)) {
            String requestBody;
            try {
                requestBody = new String(requestBodyBytes, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                requestBody = Base64.encodeBase64String(requestBodyBytes);
            }
            log.warn("invalid request. can't find sign header, please check config. [request='{}']", (Object)requestBody);
            return false;
        }
        String expectedSign = HmacUtils.hmacSha1Hex(secretToken, requestBodyBytes);
        if (!signatureHeader.equalsIgnoreCase(expectedSign)) {
            String requestBody;
            try {
                requestBody = new String(requestBodyBytes, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                requestBody = Base64.encodeBase64String(requestBodyBytes);
            }
            log.warn("check sign failed. [requestSign='{}', expectedSign='{}', requestBody='{}']", signatureHeader, expectedSign, requestBody);
            return false;
        }
        return true;
    }

    private SfUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        DEFAULT_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        DEFAULT_OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
    }
}

