/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.webhook.example;

import com.sensorsdata.webhook.Bootstrap;
import com.sensorsdata.webhook.entry.SfWebhookRequestEntry;
import com.sensorsdata.webhook.entry.SfWebhookResponseEntry;
import com.sensorsdata.webhook.middleman.SfWebhookMiddleManProcessor;
import com.sensorsdata.webhook.server.EndpointServer;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import shaded.sf.com.fasterxml.jackson.databind.ObjectMapper;

public class MiddleManServer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        EndpointServer endpointServer = Bootstrap.builder().localPort(12378).middleManProcessor(new SfWebhookMiddleManProcessor(){

            @Override
            public Request handleWebhookRequest(List<SfWebhookRequestEntry> requestEntries, HttpClient httpClient) throws Exception {
                LinkedHashMap<String, Serializable> requestBodyMap = new LinkedHashMap<String, Serializable>();
                requestBodyMap.put("proxy_time", Long.valueOf(System.currentTimeMillis()));
                ArrayList<String> userIds = new ArrayList<String>();
                for (SfWebhookRequestEntry requestEntry : requestEntries) {
                    userIds.add(requestEntry.getUserProfile().getFirstId());
                }
                requestBodyMap.put("user_id", userIds);
                String requestBody = OBJECT_MAPPER.writeValueAsString(requestBodyMap);
                Request request = httpClient.newRequest("https://webhook.site/155648c7-ff47-4328-b67e-87cea674d972").method(HttpMethod.POST).header("Hello", "World").content(new StringContentProvider("application/json", requestBody, StandardCharsets.UTF_8));
                return request;
            }

            @Override
            public List<SfWebhookResponseEntry> handleNewEndpointResponse(int responseStatusCode, String responseBody, List<SfWebhookRequestEntry> requestEntries) throws Exception {
                System.out.println("response from remote: " + responseBody);
                return Collections.emptyList();
            }
        }).build().startServer();
        endpointServer.join();
    }
}

