/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.webhook.example;

import com.sensorsdata.webhook.Bootstrap;
import com.sensorsdata.webhook.entry.SfWebhookEntry;
import com.sensorsdata.webhook.processor.SfWebhookProcessor;
import com.sensorsdata.webhook.server.EndpointServer;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleServer {
    public static void main(String[] args) throws Exception {
        EndpointServer endpointServer = Bootstrap.builder().localPort(12379).webhookProcessor(new SfWebhookProcessor(){
            private AtomicLong eventCounter = new AtomicLong(0L);

            @Override
            public void handleWebhookEntries(List<SfWebhookEntry> events) {
                for (SfWebhookEntry webhookEvent : events) {
                    long count = this.eventCounter.incrementAndGet();
                    System.out.printf("webhook request [%d]: %s%n", count, webhookEvent.getRequest());
                    if (count == 3L) {
                        webhookEvent.getResponse().failed("some reason");
                        continue;
                    }
                    webhookEvent.getResponse().succeeded();
                }
            }
        }).build().startServer();
        endpointServer.join();
    }
}

