/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.webhook.middleman;

import com.sensorsdata.webhook.common.SfUtils;
import com.sensorsdata.webhook.entry.SfWebhookRequestEntry;
import com.sensorsdata.webhook.entry.SfWebhookResponseEntry;
import com.sensorsdata.webhook.middleman.SfWebhookMiddleManProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.sf.com.fasterxml.jackson.core.type.TypeReference;
import shaded.sf.org.apache.commons.collections4.CollectionUtils;

public class SfWebhookAsyncMiddleManServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SfWebhookAsyncMiddleManServlet.class);
    private final SfWebhookMiddleManProcessor middleManProcessor;
    private final HttpClient httpClient;
    private final byte[] secretTokenForSignatureCheck;

    public SfWebhookAsyncMiddleManServlet(SfWebhookMiddleManProcessor middleManProcessor, byte[] secretTokenForSignatureCheck) {
        this.middleManProcessor = middleManProcessor;
        this.secretTokenForSignatureCheck = secretTokenForSignatureCheck;
        int selectors = Math.max(1, ProcessorUtils.availableProcessors() / 2);
        this.httpClient = new HttpClient(new HttpClientTransportOverHTTP(selectors), new SslContextFactory.Client());
    }

    @Override
    public void init() throws ServletException {
        try {
            this.httpClient.start();
        }
        catch (Exception e) {
            log.warn("start jetty http client with exception", e);
            throw new ServletException(e);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AsyncContext asyncContext = req.startAsync();
        ServletInputStream servletInputStream = req.getInputStream();
        boolean isGzip = "application/octet-stream".equals(req.getContentType());
        SfWebhookRequestBodyReadListener readListener = new SfWebhookRequestBodyReadListener(asyncContext, this.httpClient, isGzip);
        servletInputStream.setReadListener(readListener);
    }

    private class SfWebhookRequestBodyReadListener
    implements ReadListener {
        private static final int BUFFER_SIZE = 8192;
        private AsyncContext asyncContext;
        private ByteArrayOutputStream receiveBuffer;
        private HttpClient httpClient;
        private boolean isGzip;

        SfWebhookRequestBodyReadListener(AsyncContext asyncContext, HttpClient httpClient, boolean isGzip) {
            this.asyncContext = asyncContext;
            this.receiveBuffer = new ByteArrayOutputStream(asyncContext.getRequest().getContentLength());
            this.httpClient = httpClient;
            this.isGzip = isGzip;
        }

        @Override
        public void onDataAvailable() {
            try {
                int fllReadSize;
                ServletInputStream inputStream = this.asyncContext.getRequest().getInputStream();
                byte[] buffer = new byte[8192];
                while (inputStream.isReady() && !inputStream.isFinished() && (fllReadSize = inputStream.read(buffer, 0, Math.min(inputStream.available(), 8192))) != -1) {
                    this.receiveBuffer.write(buffer, 0, fllReadSize);
                }
            }
            catch (IOException e) {
                log.warn("read request with exception", e);
                this.asyncContext.complete();
            }
        }

        @Override
        public void onAllDataRead() {
            Request newRequest;
            List requestEntries;
            if (this.receiveBuffer.size() == 0) {
                ((HttpServletResponse)this.asyncContext.getResponse()).setStatus(400);
                this.asyncContext.complete();
                return;
            }
            byte[] requestBodyBytes = this.receiveBuffer.toByteArray();
            if (this.isGzip) {
                try (GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(requestBodyBytes));){
                    requestBodyBytes = IO.readBytes(gzip);
                }
                catch (IOException e) {
                    log.warn("can not decompress gzip request body bytes", e);
                    ((HttpServletResponse)this.asyncContext.getResponse()).setStatus(415);
                    this.asyncContext.complete();
                    return;
                }
            }
            if (!SfUtils.checkSignature((HttpServletRequest)this.asyncContext.getRequest(), requestBodyBytes, SfWebhookAsyncMiddleManServlet.this.secretTokenForSignatureCheck)) {
                ((HttpServletResponse)this.asyncContext.getResponse()).setStatus(403);
                this.asyncContext.complete();
                return;
            }
            try {
                requestEntries = (List)SfUtils.DEFAULT_OBJECT_MAPPER.readValue(requestBodyBytes, (TypeReference)new TypeReference<List<SfWebhookRequestEntry>>(){});
            }
            catch (IOException e) {
                int fllSize = requestBodyBytes.length;
                log.warn("can't parse request. [fll_size={}]", (Object)fllSize);
                log.warn("exception detail", e);
                ((HttpServletResponse)this.asyncContext.getResponse()).setStatus(400);
                this.asyncContext.complete();
                return;
            }
            log.info("webhook request. [requests='{}']", (Object)requestEntries);
            try {
                newRequest = SfWebhookAsyncMiddleManServlet.this.middleManProcessor.handleWebhookRequest(requestEntries, this.httpClient);
            }
            catch (Exception e) {
                log.warn("handle webhook request with exception. [requests='{}']", (Object)requestEntries);
                log.warn("exception detail", e);
                ((HttpServletResponse)this.asyncContext.getResponse()).setStatus(500);
                this.asyncContext.complete();
                return;
            }
            if (newRequest == null) {
                log.warn("request is null. [requests='{}']", (Object)requestEntries);
                ((HttpServletResponse)this.asyncContext.getResponse()).setStatus(200);
                this.asyncContext.complete();
                return;
            }
            newRequest.send(new SfRemoteResponseListener(this.asyncContext, SfWebhookAsyncMiddleManServlet.this.middleManProcessor, requestEntries));
        }

        @Override
        public void onError(Throwable t) {
            log.warn("process response with exception", t);
            if (this.asyncContext.getResponse() instanceof HttpServletResponse) {
                ((HttpServletResponse)this.asyncContext.getResponse()).setStatus(400);
            }
            this.asyncContext.complete();
        }

        protected class SfRemoteResponseListener
        extends BufferingResponseListener {
            private static final int REMOTE_RESPONSE_MAX_LENGTH = 0x200000;
            private AsyncContext asyncContext;
            private SfWebhookMiddleManProcessor middleManProcessor;
            private List<SfWebhookRequestEntry> requestEntries;

            SfRemoteResponseListener(AsyncContext asyncContext, SfWebhookMiddleManProcessor middleManProcessor, List<SfWebhookRequestEntry> requestEntries) {
                super(0x200000);
                this.asyncContext = asyncContext;
                this.middleManProcessor = middleManProcessor;
                this.requestEntries = requestEntries;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete(Result result) {
                block11: {
                    try {
                        if (result.isSucceeded()) {
                            List<SfWebhookResponseEntry> sfWebhookResponseEntries;
                            String responseBody = this.getContentAsString();
                            log.debug("new endpoint response. [response='{}']", (Object)responseBody);
                            try {
                                sfWebhookResponseEntries = this.middleManProcessor.handleNewEndpointResponse(result.getResponse().getStatus(), responseBody, this.requestEntries);
                            }
                            catch (Exception e) {
                                log.warn("handle new endpoint response with exception. [response='{}']", (Object)responseBody);
                                log.warn("exception detail", e);
                                ((HttpServletResponse)this.asyncContext.getResponse()).setStatus(500);
                                this.asyncContext.complete();
                                return;
                            }
                            if (CollectionUtils.isEmpty(sfWebhookResponseEntries)) {
                                return;
                            }
                            try {
                                this.asyncContext.getResponse().getWriter().print(SfUtils.DEFAULT_OBJECT_MAPPER.writeValueAsString(sfWebhookResponseEntries));
                            }
                            catch (IOException e) {
                                log.warn("can't write response. [new_response='{}']", (Object)sfWebhookResponseEntries);
                                log.warn("exception detail", e);
                                ((HttpServletResponse)this.asyncContext.getResponse()).setStatus(500);
                            }
                            break block11;
                        }
                        ((HttpServletResponse)this.asyncContext.getResponse()).setStatus(502);
                    }
                    finally {
                        this.asyncContext.complete();
                    }
                }
            }
        }
    }
}

