/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.webhook.processor;

import com.sensorsdata.webhook.common.SfUtils;
import com.sensorsdata.webhook.entry.SfWebhookEntry;
import com.sensorsdata.webhook.entry.SfWebhookRequestEntry;
import com.sensorsdata.webhook.entry.SfWebhookResponseEntry;
import com.sensorsdata.webhook.processor.SfWebhookProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.sf.com.fasterxml.jackson.annotation.JsonInclude;
import shaded.sf.com.fasterxml.jackson.core.type.TypeReference;
import shaded.sf.com.fasterxml.jackson.databind.DeserializationFeature;
import shaded.sf.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.sf.com.fasterxml.jackson.databind.PropertyNamingStrategy;

public class SfWebhookServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SfWebhookServlet.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final SfWebhookProcessor webhookProcessor;
    private final byte[] secretTokenForSignatureCheck;

    public SfWebhookServlet(SfWebhookProcessor webhookProcessor, byte[] secretTokenForSignatureCheck) {
        this.webhookProcessor = webhookProcessor;
        this.secretTokenForSignatureCheck = secretTokenForSignatureCheck;
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        List requestEntries;
        byte[] requestBodyBytes;
        try {
            requestBodyBytes = "application/octet-stream".equals(req.getContentType()) ? IO.readBytes(new GZIPInputStream(req.getInputStream())) : IO.readBytes(req.getInputStream());
            if (requestBodyBytes == null || requestBodyBytes.length == 0) {
                throw new IOException("request body is blank");
            }
        }
        catch (IOException e) {
            log.warn("can't read input stream.", e);
            resp.setStatus(400);
            return;
        }
        if (!SfUtils.checkSignature(req, requestBodyBytes, this.secretTokenForSignatureCheck)) {
            resp.setStatus(403);
            return;
        }
        try {
            requestEntries = (List)OBJECT_MAPPER.readValue(requestBodyBytes, (TypeReference)new TypeReference<List<SfWebhookRequestEntry>>(){});
        }
        catch (IOException e) {
            log.warn("can't parse request.", e);
            resp.setStatus(400);
            return;
        }
        if (requestEntries.isEmpty()) {
            log.warn("empty request.");
            resp.setStatus(200);
            return;
        }
        log.debug("begin process. [request='{}']", (Object)requestEntries);
        ArrayList<SfWebhookEntry> webhookEvents = new ArrayList<SfWebhookEntry>(requestEntries.size());
        for (Object requestEntry : requestEntries) {
            SfWebhookEntry sfWebhookEntry = new SfWebhookEntry();
            sfWebhookEntry.setRequest((SfWebhookRequestEntry)requestEntry);
            sfWebhookEntry.setResponse(new SfWebhookResponseEntry());
            webhookEvents.add(sfWebhookEntry);
        }
        this.webhookProcessor.handleWebhookEntries(webhookEvents);
        ArrayList<SfWebhookResponseEntry> responseEntries = new ArrayList<SfWebhookResponseEntry>(requestEntries.size());
        for (SfWebhookEntry webhookEvent : webhookEvents) {
            responseEntries.add(webhookEvent.getResponse());
        }
        log.debug("done process. [response='{}']", (Object)responseEntries);
        try {
            resp.getOutputStream().write(OBJECT_MAPPER.writeValueAsBytes(responseEntries));
        }
        catch (IOException e) {
            log.warn("can't write result. [events='{}']", (Object)webhookEvents);
            log.warn("exception detail", e);
            resp.setStatus(500);
        }
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

