/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.webhook.server;

import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointServer {
    private static final Logger log = LoggerFactory.getLogger(EndpointServer.class);
    private Server jettyServer;

    public void startServer(int localPort, HttpServlet servlet, int threadPoolMaxSize) throws Exception {
        QueuedThreadPool serverPool = new QueuedThreadPool(threadPoolMaxSize);
        serverPool.setName("server");
        this.jettyServer = new Server(serverPool);
        ServerConnector serverConnector = new ServerConnector(this.jettyServer);
        serverConnector.setPort(localPort);
        this.jettyServer.addConnector(serverConnector);
        ServletContextHandler appCtx = new ServletContextHandler(this.jettyServer, "/", true, false);
        appCtx.addServlet(new ServletHolder(servlet), "/");
        this.jettyServer.start();
    }

    public void stop() throws Exception {
        if (this.jettyServer != null) {
            this.jettyServer.stop();
        }
    }

    public void join() throws InterruptedException {
        if (this.jettyServer != null) {
            this.jettyServer.join();
        }
    }
}

