/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThread;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Formatter;
import java.util.logging.Logger;

public class ElectionAgentThread
extends StoppableThread {
    protected final Protocol protocol;
    protected final Logger logger;
    protected final Formatter formatter;
    protected final BlockingQueue<SocketChannel> channelQueue = new LinkedBlockingQueue<SocketChannel>();

    protected ElectionAgentThread(RepNode repNode, Protocol protocol, NameIdPair nameIdPair) {
        super(repNode == null ? null : repNode.getRepImpl());
        this.protocol = protocol;
        this.logger = this.envImpl != null ? LoggerUtils.getLogger(this.getClass()) : LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(nameIdPair);
    }

    protected ElectionAgentThread(RepNode repNode, Protocol protocol) {
        this(repNode, protocol, repNode.getNameIdPair());
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void shutdown() throws InterruptedException {
        if (this.shutdownDone()) {
            return;
        }
        this.shutdownThread(this.logger);
    }

    protected int initiateSoftShutdown() {
        this.channelQueue.clear();
        this.channelQueue.add(RepUtils.CHANNEL_EOF_MARKER);
        return 0;
    }
}

