/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.function;

import com.speedment.common.function.BooleanConsumer;
import com.speedment.common.function.BooleanPredicate;
import java.util.function.Supplier;

public enum OptionalBoolean {
    FALSE,
    TRUE,
    EMPTY;


    public static OptionalBoolean empty() {
        return EMPTY;
    }

    public static OptionalBoolean of(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public static OptionalBoolean ofNullable(Boolean bool) {
        if (bool == null) {
            return OptionalBoolean.empty();
        }
        return OptionalBoolean.of(bool);
    }

    public OptionalBoolean filter(BooleanPredicate predicate) {
        if (this == EMPTY || predicate.test(this.getAsBoolean())) {
            return this;
        }
        return EMPTY;
    }

    public boolean getAsBoolean() {
        switch (this) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
        }
        throw new NullPointerException("Attempted to get value from empty OptionalBoolean.");
    }

    public boolean orElse(boolean ifEmpty) {
        switch (this) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
        }
        return ifEmpty;
    }

    public <T extends Throwable> boolean orElseThrow(Supplier<T> thrower) throws T {
        switch (this) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
        }
        throw (Throwable)thrower.get();
    }

    public boolean isPresent() {
        return this != EMPTY;
    }

    public void ifPresent(BooleanConsumer consumer) {
        switch (this) {
            case FALSE: {
                consumer.accept(false);
                break;
            }
            case TRUE: {
                consumer.accept(true);
                break;
            }
        }
    }
}

