/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector;

import com.speedment.common.injector.InjectBundle;
import com.speedment.common.injector.Injector;
import com.speedment.common.injector.exception.NoDefaultConstructorException;
import com.speedment.common.injector.execution.ExecutionBuilder;
import com.speedment.common.injector.internal.InjectorBuilderImpl;
import com.speedment.common.logger.Logger;
import java.nio.file.Path;
import java.util.function.Consumer;

public interface InjectorBuilder {
    public InjectorBuilder withComponent(Class<?> var1) throws NoDefaultConstructorException;

    public InjectorBuilder withBundle(Class<? extends InjectBundle> var1) throws NoDefaultConstructorException;

    public InjectorBuilder withParam(String var1, String var2);

    public InjectorBuilder withConfigFileLocation(Path var1);

    public <T> InjectorBuilder before(ExecutionBuilder<T> var1);

    default public <T> InjectorBuilder beforeInitialized(Class<T> injectableType, Consumer<T> action) {
        return this.before(ExecutionBuilder.initialized(injectableType).withExecute(action));
    }

    default public <T> InjectorBuilder beforeResolved(Class<T> injectableType, Consumer<T> action) {
        return this.before(ExecutionBuilder.resolved(injectableType).withExecute(action));
    }

    default public <T> InjectorBuilder beforeStarted(Class<T> injectableType, Consumer<T> action) {
        return this.before(ExecutionBuilder.started(injectableType).withExecute(action));
    }

    default public <T> InjectorBuilder beforeStopped(Class<T> injectableType, Consumer<T> action) {
        return this.before(ExecutionBuilder.stopped(injectableType).withExecute(action));
    }

    public Injector build() throws InstantiationException;

    public static Logger logger() {
        return InjectorBuilderImpl.LOGGER;
    }
}

