/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal;

import com.speedment.common.injector.InjectBundle;
import com.speedment.common.injector.Injector;
import com.speedment.common.injector.InjectorBuilder;
import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.Config;
import com.speedment.common.injector.annotation.Inject;
import com.speedment.common.injector.annotation.InjectKey;
import com.speedment.common.injector.annotation.WithState;
import com.speedment.common.injector.dependency.DependencyGraph;
import com.speedment.common.injector.dependency.DependencyNode;
import com.speedment.common.injector.exception.NoDefaultConstructorException;
import com.speedment.common.injector.exception.NotInjectableException;
import com.speedment.common.injector.execution.Execution;
import com.speedment.common.injector.execution.ExecutionBuilder;
import com.speedment.common.injector.internal.InjectorImpl;
import com.speedment.common.injector.internal.dependency.DependencyGraphImpl;
import com.speedment.common.injector.internal.util.InjectorUtil;
import com.speedment.common.injector.internal.util.PrintUtil;
import com.speedment.common.injector.internal.util.PropertiesUtil;
import com.speedment.common.injector.internal.util.ReflectionUtil;
import com.speedment.common.logger.Level;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public final class InjectorBuilderImpl
implements InjectorBuilder {
    public static final Logger LOGGER = LoggerManager.getLogger(InjectorBuilderImpl.class);
    private final ClassLoader classLoader;
    private final Map<String, List<Class<?>>> injectables;
    private final List<ExecutionBuilder<?>> executions;
    private final Map<String, String> overriddenParams;
    private Path configFileLocation;

    InjectorBuilderImpl() {
        this(InjectorBuilderImpl.defaultClassLoader(), Collections.emptySet());
    }

    InjectorBuilderImpl(ClassLoader classLoader) {
        this(classLoader, Collections.emptySet());
    }

    InjectorBuilderImpl(Set<Class<?>> injectables) {
        this(InjectorBuilderImpl.defaultClassLoader(), injectables);
    }

    InjectorBuilderImpl(ClassLoader classLoader, Set<Class<?>> injectables) {
        Objects.requireNonNull(injectables);
        this.classLoader = Objects.requireNonNull(classLoader);
        this.injectables = new LinkedHashMap();
        this.executions = new LinkedList();
        this.overriddenParams = new HashMap<String, String>();
        this.configFileLocation = Paths.get("settings.properties", new String[0]);
        injectables.forEach(this::withComponent);
    }

    @Override
    public InjectorBuilder withComponent(Class<?> injectableType) {
        Objects.requireNonNull(injectableType);
        ReflectionUtil.traverseAncestors(injectableType).filter(c -> c == injectableType || ReflectionUtil.traverseAncestors(c).anyMatch(c2 -> c2.isAnnotationPresent(InjectKey.class))).forEachOrdered(c -> {
            this.appendInjectable(c.getName(), injectableType, true);
            if (c.isAnnotationPresent(InjectKey.class)) {
                InjectKey key = c.getAnnotation(InjectKey.class);
                this.appendInjectable(key.value().getName(), injectableType, key.overwrite());
            }
        });
        return this;
    }

    @Override
    public InjectorBuilder withBundle(Class<? extends InjectBundle> bundleClass) {
        try {
            InjectBundle bundle = bundleClass.newInstance();
            bundle.injectables().forEach(this::withComponent);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new NoDefaultConstructorException(e);
        }
        return this;
    }

    @Override
    public InjectorBuilder withConfigFileLocation(Path configFile) {
        this.configFileLocation = Objects.requireNonNull(configFile);
        return this;
    }

    @Override
    public InjectorBuilder withParam(String name, String value) {
        this.overriddenParams.put(name, value);
        return this;
    }

    @Override
    public <T> InjectorBuilder before(ExecutionBuilder<T> executionBuilder) {
        this.executions.add(Objects.requireNonNull(executionBuilder));
        return this;
    }

    @Override
    public Injector build() throws InstantiationException, NoDefaultConstructorException {
        File configFile = this.configFileLocation.toFile();
        Properties properties = PropertiesUtil.loadProperties(LOGGER, configFile);
        this.overriddenParams.forEach(properties::setProperty);
        Set<Class<?>> injectablesSet = Collections.unmodifiableSet(this.injectables.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(() -> new LinkedHashSet())));
        DependencyGraph graph = DependencyGraphImpl.create(injectablesSet);
        final LinkedList instances = new LinkedList();
        LOGGER.debug("Creating " + injectablesSet.size() + " injectable instances.");
        LOGGER.debug(PrintUtil.horizontalLine());
        for (Class<?> injectable : injectablesSet) {
            if (LOGGER.getLevel().isEqualOrLowerThan(Level.DEBUG)) {
                LOGGER.debug("| %-71s CREATED |", (Object)PrintUtil.limit(injectable.getSimpleName(), 71));
                ReflectionUtil.traverseFields(injectable).filter(f -> f.isAnnotationPresent(Config.class)).map(f -> f.getAnnotation(Config.class)).map(a -> String.format("|     %-48s %26s |", PrintUtil.limit(a.name(), 48), PrintUtil.limit(properties.containsKey(a.name()) ? properties.get(a.name()).toString() : a.value(), 26))).forEachOrdered(arg_0 -> ((Logger)LOGGER).debug(arg_0));
                LOGGER.debug(PrintUtil.horizontalLine());
            }
            Object instance2 = ReflectionUtil.newInstance(injectable, properties);
            instances.addFirst(instance2);
        }
        final InjectorImpl injector = new InjectorImpl(injectablesSet, Collections.unmodifiableList(instances), properties, this.classLoader, graph, this);
        Execution.ClassMapper classMapper = new Execution.ClassMapper(){

            @Override
            public <T> T apply(Class<T> type) throws NotInjectableException {
                return InjectorUtil.findIn(type, injector, instances, true);
            }
        };
        instances.forEach(instance -> ReflectionUtil.traverseFields(instance.getClass()).filter(f -> f.isAnnotationPresent(Inject.class)).distinct().forEachOrdered(field -> {
            Injector value = Inject.class.isAssignableFrom(field.getType()) ? injector : InjectorUtil.findIn(field.getType(), injector, instances, field.getAnnotation(WithState.class) != null);
            field.setAccessible(true);
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not access field '" + field.getName() + "' in class '" + value.getClass().getName() + "' of type '" + field.getType() + "'.", ex);
            }
        }));
        this.executions.stream().map(builder -> builder.build(graph)).forEachOrdered(execution -> {
            DependencyNode node = graph.get(execution.getType());
            node.getExecutions().add((Execution<?>)execution);
        });
        AtomicBoolean hasAnythingChanged = new AtomicBoolean();
        AtomicInteger nextState = new AtomicInteger(0);
        while (nextState.get() <= State.STARTED.ordinal()) {
            Set<DependencyNode> unfinished;
            while (!(unfinished = graph.nodes().filter(n -> n.getCurrentState().ordinal() < nextState.get()).collect(Collectors.toSet())).isEmpty()) {
                hasAnythingChanged.set(false);
                unfinished.forEach(n -> {
                    State state = State.values()[n.getCurrentState().ordinal() + 1];
                    if (n.canBe(state)) {
                        LOGGER.debug(PrintUtil.horizontalLine());
                        Object instance = InjectorUtil.findIn(n.getRepresentedType(), injector, instances, true);
                        n.getExecutions().stream().filter(e -> e.getState() == state).map(exec -> {
                            Execution casted = exec;
                            return casted;
                        }).forEach(exec -> {
                            if (LOGGER.getLevel().isEqualOrLowerThan(Level.DEBUG)) {
                                LOGGER.debug("| -> %-76s |", (Object)PrintUtil.limit(exec.toString(), 76));
                            }
                            try {
                                exec.invoke(instance, classMapper);
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                                throw new RuntimeException(ex);
                            }
                        });
                        n.setState(state);
                        hasAnythingChanged.set(true);
                        LOGGER.debug("| %-66s %12s |", (Object)PrintUtil.limit(n.getRepresentedType().getSimpleName(), 66), (Object)PrintUtil.limit(state.name(), 12));
                    }
                });
                if (hasAnythingChanged.get()) continue;
                throw new IllegalStateException("Injector appears to be stuck in an infinite loop.");
            }
            nextState.incrementAndGet();
        }
        LOGGER.debug(PrintUtil.horizontalLine());
        LOGGER.debug("| %-79s |", (Object)("All " + instances.size() + " components have been configured!"));
        LOGGER.debug(PrintUtil.horizontalLine());
        return injector;
    }

    private void appendInjectable(String key, Class<?> clazz, boolean overwrite) {
        List list = Optional.ofNullable(this.injectables.remove(key)).orElseGet(LinkedList::new);
        if (overwrite) {
            list.clear();
        }
        list.add(clazz);
        this.injectables.put(key, list);
    }

    private static ClassLoader defaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

