/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal;

import com.speedment.common.injector.Injector;
import com.speedment.common.injector.InjectorBuilder;
import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.Inject;
import com.speedment.common.injector.annotation.WithState;
import com.speedment.common.injector.dependency.DependencyGraph;
import com.speedment.common.injector.dependency.DependencyNode;
import com.speedment.common.injector.exception.NotInjectableException;
import com.speedment.common.injector.execution.Execution;
import com.speedment.common.injector.internal.InjectorBuilderImpl;
import com.speedment.common.injector.internal.util.InjectorUtil;
import com.speedment.common.injector.internal.util.PrintUtil;
import com.speedment.common.injector.internal.util.PropertiesUtil;
import com.speedment.common.injector.internal.util.ReflectionUtil;
import com.speedment.common.logger.Level;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerManager;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class InjectorImpl
implements Injector {
    public static final Logger LOGGER = LoggerManager.getLogger(InjectorImpl.class);
    private final Set<Class<?>> injectables;
    private final List<Object> instances;
    private final Properties properties;
    private final ClassLoader classLoader;
    private final DependencyGraph graph;
    private final InjectorBuilder builder;

    public static InjectorBuilder builder() {
        return new InjectorBuilderImpl();
    }

    public static InjectorBuilder builder(ClassLoader classLoader) {
        return new InjectorBuilderImpl(classLoader);
    }

    InjectorImpl(Set<Class<?>> injectables, List<Object> instances, Properties properties, ClassLoader classLoader, DependencyGraph graph, InjectorBuilder builder) {
        this.injectables = Objects.requireNonNull(injectables);
        this.instances = Objects.requireNonNull(instances);
        this.properties = Objects.requireNonNull(properties);
        this.classLoader = Objects.requireNonNull(classLoader);
        this.graph = Objects.requireNonNull(graph);
        this.builder = Objects.requireNonNull(builder);
    }

    @Override
    public <T> Stream<T> stream(Class<T> type) {
        return this.findAll(type);
    }

    @Override
    public <T> T getOrThrow(Class<T> type) throws IllegalArgumentException {
        return this.find(type, true);
    }

    @Override
    public <T> Optional<T> get(Class<T> type) {
        return Optional.ofNullable(this.find(type, false));
    }

    @Override
    public Stream<Class<?>> injectables() {
        return this.injectables.stream();
    }

    @Override
    public <T> T inject(T instance) {
        this.injectFields(instance);
        PropertiesUtil.configureParams(instance, this.properties);
        return instance;
    }

    @Override
    public ClassLoader classLoader() {
        return this.classLoader;
    }

    @Override
    public void stop() {
        Set<DependencyNode> unfinished;
        AtomicBoolean hasAnythingChanged = new AtomicBoolean();
        Execution.ClassMapper classMapper = new Execution.ClassMapper(){

            @Override
            public <T> T apply(Class<T> type) throws NotInjectableException {
                return (T)InjectorImpl.this.find(type, true);
            }
        };
        while (!(unfinished = this.graph.nodes().filter(n -> n.getCurrentState() != State.STOPPED).collect(Collectors.toSet())).isEmpty()) {
            hasAnythingChanged.set(false);
            unfinished.forEach(n -> {
                if (n.canBe(State.STOPPED)) {
                    LOGGER.debug(PrintUtil.horizontalLine());
                    Object inst = this.find(n.getRepresentedType(), true);
                    n.getExecutions().stream().filter(e -> e.getState() == State.STOPPED).map(exec -> {
                        Execution casted = exec;
                        return casted;
                    }).forEach(exec -> {
                        if (LOGGER.getLevel().isEqualOrLowerThan(Level.DEBUG)) {
                            LOGGER.debug("| -> %-76s |", (Object)PrintUtil.limit(exec.toString(), 76));
                        }
                        try {
                            exec.invoke(inst, classMapper);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                            throw new RuntimeException(ex);
                        }
                    });
                    n.setState(State.STOPPED);
                    hasAnythingChanged.set(true);
                    LOGGER.debug("| %-66s %12s |", (Object)n.getRepresentedType().getSimpleName(), (Object)State.STOPPED.name());
                }
            });
            if (hasAnythingChanged.get()) continue;
            throw new IllegalStateException("Injector appears to be stuck in an infinite loop. The following componenets have not been stopped: " + unfinished.stream().map(DependencyNode::getRepresentedType).map(Class::getSimpleName).collect(Collectors.toSet()));
        }
        LOGGER.debug(PrintUtil.horizontalLine());
        LOGGER.debug("| %-79s |", (Object)("All " + this.instances.size() + " components have been stopped!"));
        LOGGER.debug(PrintUtil.horizontalLine());
    }

    @Override
    public InjectorBuilder newBuilder() {
        return this.builder;
    }

    private <T> Stream<T> findAll(Class<T> type) {
        return InjectorUtil.findAll(type, this, this.instances);
    }

    private <T> T find(Class<T> type, boolean required) {
        return InjectorUtil.findIn(type, this, this.instances, required);
    }

    private <T> void injectFields(T instance) {
        Objects.requireNonNull(instance);
        ReflectionUtil.traverseFields(instance.getClass()).filter(f -> f.isAnnotationPresent(Inject.class)).distinct().forEachOrdered(field -> {
            InjectorImpl value = Injector.class.isAssignableFrom(field.getType()) ? this : this.find(field.getType(), field.getAnnotation(WithState.class) != null);
            field.setAccessible(true);
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException ex) {
                String err = "Could not access field '" + field.getName() + "' in class '" + value.getClass().getName() + "' of type '" + field.getType() + "'.";
                LOGGER.error((Throwable)ex, err);
                throw new RuntimeException(err, ex);
            }
        });
    }
}

