/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal.dependency;

import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.Execute;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.common.injector.annotation.WithState;
import com.speedment.common.injector.dependency.Dependency;
import com.speedment.common.injector.dependency.DependencyGraph;
import com.speedment.common.injector.dependency.DependencyNode;
import com.speedment.common.injector.exception.CyclicReferenceException;
import com.speedment.common.injector.execution.Execution;
import com.speedment.common.injector.internal.InjectorImpl;
import com.speedment.common.injector.internal.dependency.DependencyImpl;
import com.speedment.common.injector.internal.dependency.DependencyNodeImpl;
import com.speedment.common.injector.internal.dependency.InjectorDependencyNode;
import com.speedment.common.injector.internal.execution.ReflectionExecutionImpl;
import com.speedment.common.injector.internal.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DependencyGraphImpl
implements DependencyGraph {
    private final Map<Class<?>, DependencyNode> nodes = new ConcurrentHashMap();

    public static DependencyGraph create(Set<Class<?>> injectables) throws CyclicReferenceException {
        DependencyGraphImpl graph = new DependencyGraphImpl();
        injectables.forEach(graph::getOrCreate);
        graph.inject();
        return graph;
    }

    private DependencyGraphImpl() {
        this.nodes.put(InjectorImpl.class, new InjectorDependencyNode());
    }

    @Override
    public DependencyNode get(Class<?> clazz) throws IllegalArgumentException {
        for (Class<?> impl : this.nodes.keySet()) {
            if (!clazz.isAssignableFrom(impl)) continue;
            return this.nodes.get(impl);
        }
        throw new IllegalArgumentException("There is no implementation of '" + clazz + "' in the injection dependency graph.");
    }

    @Override
    public DependencyNode getOrCreate(Class<?> clazz) {
        return this.nodes.computeIfAbsent(clazz, DependencyNodeImpl::new);
    }

    @Override
    public DependencyGraph inject() {
        this.nodes.forEach((clazz, node) -> {
            ReflectionUtil.traverseMethods(clazz).filter(m -> m.isAnnotationPresent(Execute.class)).forEach(m -> node.getExecutions().add(this.createExecution((Method)m, State.STARTED)));
            ReflectionUtil.traverseMethods(clazz).filter(m -> m.isAnnotationPresent(ExecuteBefore.class)).forEach(m -> {
                ExecuteBefore execute = m.getAnnotation(ExecuteBefore.class);
                node.getExecutions().add(this.createExecution((Method)m, execute.value()));
            });
        });
        return this;
    }

    @Override
    public Stream<DependencyNode> nodes() {
        return this.nodes.values().stream();
    }

    private static String methodName(Method m) {
        return m.getDeclaringClass().getName() + "#" + m.getName() + "(" + Stream.of(m.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")";
    }

    private Execution<?> createExecution(Method m, State executeBefore) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        try {
            for (int i = 0; i < m.getParameterCount(); ++i) {
                Parameter p = m.getParameters()[i];
                WithState ws = p.getAnnotation(WithState.class);
                if (ws == null) continue;
                Class<?> type = p.getType();
                State state = ws.value();
                try {
                    dependencies.add(new DependencyImpl(this.get(type), state));
                    continue;
                }
                catch (CyclicReferenceException ex) {
                    throw new CyclicReferenceException(m.getDeclaringClass(), ex);
                }
            }
        }
        catch (CyclicReferenceException ex) {
            throw new IllegalStateException("Could not execute method " + DependencyGraphImpl.methodName(m) + " since one of its dependencies had not been injected.", ex);
        }
        return new ReflectionExecutionImpl(m.getDeclaringClass(), executeBefore, dependencies, m);
    }
}

