/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal.dependency;

import com.speedment.common.injector.State;
import com.speedment.common.injector.dependency.Dependency;
import com.speedment.common.injector.dependency.DependencyNode;
import com.speedment.common.injector.execution.Execution;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DependencyNodeImpl
implements DependencyNode {
    private final Class<?> representedType;
    private final Set<Dependency> dependencies;
    private final List<Execution<?>> executions;
    private State currentState;

    public DependencyNodeImpl(Class<?> representedType) {
        this.representedType = Objects.requireNonNull(representedType);
        this.dependencies = Collections.newSetFromMap(new ConcurrentHashMap());
        this.executions = new CopyOnWriteArrayList();
        this.currentState = State.CREATED;
    }

    @Override
    public Class<?> getRepresentedType() {
        return this.representedType;
    }

    @Override
    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<Execution<?>> getExecutions() {
        return this.executions;
    }

    @Override
    public State getCurrentState() {
        return this.currentState;
    }

    @Override
    public void setState(State newState) {
        this.currentState = Objects.requireNonNull(newState);
    }

    @Override
    public boolean canBe(State state) {
        return this.executions.stream().filter(e -> e.getState().ordinal() <= state.ordinal()).flatMap(e -> e.getDependencies().stream()).map(Dependency::getNode).allMatch(node -> node.is(state));
    }

    @Override
    public boolean is(State state) {
        return this.currentState.ordinal() >= state.ordinal();
    }
}

