/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal.execution;

import com.speedment.common.injector.State;
import com.speedment.common.injector.dependency.Dependency;
import com.speedment.common.injector.execution.Execution;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

abstract class AbstractExecution<T>
implements Execution<T> {
    private final Class<T> type;
    private final State state;
    private final Set<Dependency> dependencies;

    AbstractExecution(Class<T> type, State state, Set<Dependency> dependencies) {
        this.type = Objects.requireNonNull(type);
        this.state = Objects.requireNonNull(state);
        this.dependencies = Objects.requireNonNull(dependencies);
    }

    @Override
    public final Class<T> getType() {
        return this.type;
    }

    @Override
    public final State getState() {
        return this.state;
    }

    @Override
    public final Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        return "<execute>(" + this.dependencies.stream().map(d -> d.getNode().getRepresentedType().getSimpleName() + "[" + d.getRequiredState().name().toLowerCase() + "]").collect(Collectors.joining(", ")) + ")";
    }
}

