/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal.execution;

import com.speedment.common.injector.State;
import com.speedment.common.injector.dependency.Dependency;
import com.speedment.common.injector.exception.NotInjectableException;
import com.speedment.common.injector.execution.Execution;
import com.speedment.common.injector.internal.execution.AbstractExecution;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ReflectionExecutionImpl<T>
extends AbstractExecution<T> {
    private final Method method;

    public ReflectionExecutionImpl(Class<T> component, State state, Set<Dependency> dependencies, Method method) {
        super(component, state, dependencies);
        this.method = Objects.requireNonNull(method);
    }

    @Override
    public void invoke(T component, Execution.ClassMapper classMapper) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NotInjectableException {
        Object[] args = Stream.of(this.method.getParameters()).map(Parameter::getType).map(classMapper::apply).toArray();
        this.method.setAccessible(true);
        this.method.invoke(component, args);
    }

    @Override
    public String toString() {
        return this.getType().getSimpleName() + "#" + this.method.getName() + "(" + Stream.of(this.method.getParameters()).map(p -> p.getType().getSimpleName().substring(0, 1)).collect(Collectors.joining(", ")) + ")";
    }
}

