/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal.util;

import com.speedment.common.injector.annotation.Config;
import com.speedment.common.injector.internal.util.ReflectionUtil;
import com.speedment.common.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public final class PropertiesUtil {
    public static Properties loadProperties(Logger logger, File configFile) {
        Properties properties;
        block15: {
            properties = new Properties();
            if (configFile.exists() && configFile.canRead()) {
                try (FileInputStream in = new FileInputStream(configFile);){
                    properties.load(in);
                    break block15;
                }
                catch (IOException ex) {
                    String err = "Error loading default settings from " + configFile.getAbsolutePath() + "-file.";
                    logger.error((Throwable)ex, err);
                    throw new RuntimeException(err, ex);
                }
            }
            logger.info("No configuration file '" + configFile.getAbsolutePath() + "' found.");
        }
        return properties;
    }

    public static <T> void configureParams(T instance, Properties properties) {
        ReflectionUtil.traverseFields(instance.getClass()).filter(f -> f.isAnnotationPresent(Config.class)).forEach(f -> {
            block15: {
                Config config = f.getAnnotation(Config.class);
                String serialized = properties.containsKey(config.name()) ? properties.getProperty(config.name()) : config.value();
                f.setAccessible(true);
                try {
                    if (Boolean.TYPE == f.getType() || Boolean.class.isAssignableFrom(f.getType())) {
                        f.set(instance, Boolean.parseBoolean(serialized));
                        break block15;
                    }
                    if (Byte.TYPE == f.getType() || Byte.class.isAssignableFrom(f.getType())) {
                        f.set(instance, Byte.parseByte(serialized));
                        break block15;
                    }
                    if (Short.TYPE == f.getType() || Short.class.isAssignableFrom(f.getType())) {
                        f.set(instance, Short.parseShort(serialized));
                        break block15;
                    }
                    if (Integer.TYPE == f.getType() || Integer.class.isAssignableFrom(f.getType())) {
                        f.set(instance, Integer.parseInt(serialized));
                        break block15;
                    }
                    if (Long.TYPE == f.getType() || Long.class.isAssignableFrom(f.getType())) {
                        f.set(instance, Long.parseLong(serialized));
                        break block15;
                    }
                    if (Float.TYPE == f.getType() || Float.class.isAssignableFrom(f.getType())) {
                        f.set(instance, Float.valueOf(Float.parseFloat(serialized)));
                        break block15;
                    }
                    if (Double.TYPE == f.getType() || Double.class.isAssignableFrom(f.getType())) {
                        f.set(instance, Double.parseDouble(serialized));
                        break block15;
                    }
                    if (String.class.isAssignableFrom(f.getType())) {
                        f.set(instance, serialized);
                        break block15;
                    }
                    if (Character.TYPE == f.getType() || Character.class.isAssignableFrom(f.getType())) {
                        if (serialized.length() == 1) {
                            f.set(instance, Character.valueOf(serialized.charAt(0)));
                            break block15;
                        }
                        throw new IllegalArgumentException("Value '" + serialized + "' is to long to be parsed into a field of type '" + f.getType().getName() + "'.");
                    }
                    if (File.class.isAssignableFrom(f.getType())) {
                        f.set(instance, new File(serialized));
                        break block15;
                    }
                    if (!URL.class.isAssignableFrom(f.getType())) break block15;
                    try {
                        f.set(instance, new URL(serialized));
                    }
                    catch (MalformedURLException ex) {
                        throw new IllegalArgumentException("Specified URL '" + serialized + "' is malformed.", ex);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    throw new RuntimeException("Failed to set config parameter '" + config.name() + "' in class '" + instance.getClass().getName() + "'.", ex);
                }
            }
        });
    }

    private PropertiesUtil() {
    }
}

