/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.injector.internal.util;

import com.speedment.common.injector.exception.NoDefaultConstructorException;
import com.speedment.common.injector.internal.util.PropertiesUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.stream.Stream;

public final class ReflectionUtil {
    public static Stream<Field> traverseFields(Class<?> clazz) {
        Class<?> parent = clazz.getSuperclass();
        Stream<Object> inherited = parent != null ? ReflectionUtil.traverseFields(parent) : Stream.empty();
        return Stream.concat(inherited, Stream.of(clazz.getDeclaredFields()));
    }

    public static Stream<Method> traverseMethods(Class<?> clazz) {
        return ReflectionUtil.traverseAncestors(clazz).flatMap(c -> Stream.of(c.getDeclaredMethods()));
    }

    public static Stream<Class<?>> traverseAncestors(Class<?> clazz) {
        if (clazz.getSuperclass() == null) {
            return Stream.of(clazz);
        }
        return Stream.concat(Stream.of(clazz), Stream.concat(ReflectionUtil.traverseAncestors(clazz.getSuperclass()), Stream.of(clazz.getInterfaces()))).distinct();
    }

    public static <T> T newInstance(Class<T> type, Properties properties) throws InstantiationException, NoDefaultConstructorException {
        try {
            Constructor<T> constr = type.getDeclaredConstructor(new Class[0]);
            constr.setAccessible(true);
            T instance = constr.newInstance(new Object[0]);
            PropertiesUtil.configureParams(instance, properties);
            return instance;
        }
        catch (NoSuchMethodException ex) {
            throw new NoDefaultConstructorException("Could not find any default constructor for class '" + type.getName() + "'.", ex);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException("Unable to create class '" + type.getName() + "'", ex);
        }
    }

    private ReflectionUtil() {
    }
}

