/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.invariant;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class NullUtil {
    private static final String FIRST_ARG_IS_NULL = "First argument is null";
    private static final String SECOND_ARG_IS_NULL = "Second argument is null";
    private static final String THIRD_ARG_IS_NULL = "Third argument is null";
    private static final String FOURTH_ARG_IS_NULL = "Fourth argument is null";
    private static final String FIFTH_ARG_IS_NULL = "Fifth argument is null";
    private static final String SIXTH_ARG_IS_NULL = "Sixth argument is null";
    private static final String SEVENTH_ARG_IS_NULL = "Seventh argument is null";
    private static final String EIGHT_ARG_IS_NULL = "Eight argument is null";

    public static <T> T[] requireNonNullElements(T[] array) {
        Objects.requireNonNull(array, "The provided array is null.");
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] != null) continue;
            throw new NullPointerException("Item " + i + " in the array " + Arrays.toString(array) + " is null");
        }
        return array;
    }

    public static <E, T extends Collection<E>> T requireNonNullElements(T collection) {
        Objects.requireNonNull(collection, "The provided collection is null.");
        int i = 0;
        for (E item : collection) {
            if (item == null) {
                throw new NullPointerException("Element " + i + " in the collection " + collection + " is null");
            }
            ++i;
        }
        return collection;
    }

    public static <T> T[] requireNonNullElements(T[] array, String msg) {
        Objects.requireNonNull(array, msg);
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] != null) continue;
            throw new NullPointerException(msg + ", item " + i + " in the array " + Arrays.toString(array) + " is null");
        }
        return array;
    }

    public static void requireNonNulls(Object o0) {
        if (o0 == null) {
            throw new NullPointerException(FIRST_ARG_IS_NULL);
        }
    }

    public static void requireNonNulls(Object o0, Object o1) {
        if (o0 == null) {
            throw new NullPointerException(FIRST_ARG_IS_NULL);
        }
        if (o1 == null) {
            throw new NullPointerException(SECOND_ARG_IS_NULL);
        }
    }

    public static void requireNonNulls(Object o0, Object o1, Object o2) {
        if (o0 == null) {
            throw new NullPointerException(FIRST_ARG_IS_NULL);
        }
        if (o1 == null) {
            throw new NullPointerException(SECOND_ARG_IS_NULL);
        }
        if (o2 == null) {
            throw new NullPointerException(THIRD_ARG_IS_NULL);
        }
    }

    public static void requireNonNulls(Object o0, Object o1, Object o2, Object o3) {
        if (o0 == null) {
            throw new NullPointerException(FIRST_ARG_IS_NULL);
        }
        if (o1 == null) {
            throw new NullPointerException(SECOND_ARG_IS_NULL);
        }
        if (o2 == null) {
            throw new NullPointerException(THIRD_ARG_IS_NULL);
        }
        if (o3 == null) {
            throw new NullPointerException(FOURTH_ARG_IS_NULL);
        }
    }

    public static void requireNonNulls(Object o0, Object o1, Object o2, Object o3, Object o4) {
        if (o0 == null) {
            throw new NullPointerException(FIRST_ARG_IS_NULL);
        }
        if (o1 == null) {
            throw new NullPointerException(SECOND_ARG_IS_NULL);
        }
        if (o2 == null) {
            throw new NullPointerException(THIRD_ARG_IS_NULL);
        }
        if (o3 == null) {
            throw new NullPointerException(FOURTH_ARG_IS_NULL);
        }
        if (o4 == null) {
            throw new NullPointerException(FIFTH_ARG_IS_NULL);
        }
    }

    public static void requireNonNulls(Object o0, Object o1, Object o2, Object o3, Object o4, Object o5) {
        NullUtil.requireNonNulls(o0, o1, o2, o3, o4);
        if (o5 == null) {
            throw new NullPointerException(SIXTH_ARG_IS_NULL);
        }
    }

    public static void requireNonNulls(Object o0, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        NullUtil.requireNonNulls(o0, o1, o2, o3, o4);
        if (o5 == null) {
            throw new NullPointerException(SIXTH_ARG_IS_NULL);
        }
        if (o6 == null) {
            throw new NullPointerException(SEVENTH_ARG_IS_NULL);
        }
    }

    public static void requireNonNulls(Object o0, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        NullUtil.requireNonNulls(o0, o1, o2, o3, o4);
        if (o5 == null) {
            throw new NullPointerException(SIXTH_ARG_IS_NULL);
        }
        if (o6 == null) {
            throw new NullPointerException(SEVENTH_ARG_IS_NULL);
        }
        if (o7 == null) {
            throw new NullPointerException(EIGHT_ARG_IS_NULL);
        }
    }

    @SafeVarargs
    public static <K, V> Map<K, V> requireKeys(Map<K, V> map, K ... requiredKeys) {
        Objects.requireNonNull(map);
        NullUtil.requireNonNullElements(requiredKeys);
        for (K key : requiredKeys) {
            if (map.containsKey(key)) continue;
            throw new NoSuchElementException("The Map does not contain the key " + key);
        }
        return map;
    }

    public static <K, V> Map<K, V> requireKeys(Map<K, V> map, K requiredKey) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(requiredKey);
        if (!map.containsKey(requiredKey)) {
            throw new NoSuchElementException("The Map does not contain the key " + requiredKey);
        }
        return map;
    }

    public static <K, V> Map<K, V> requireKeys(Map<K, V> map, K requiredKeyA, K requiredKeyB) {
        NullUtil.requireKeys(map, requiredKeyA);
        NullUtil.requireKeys(map, requiredKeyB);
        return map;
    }

    public static <K, V> Map<K, V> requireKeys(Map<K, V> map, K requiredKeyA, K requiredKeyB, K requiredKeyC) {
        NullUtil.requireKeys(map, requiredKeyA);
        NullUtil.requireKeys(map, requiredKeyB);
        NullUtil.requireKeys(map, requiredKeyC);
        return map;
    }

    private NullUtil() {
        throw new UnsupportedOperationException();
    }
}

