/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.json;

import com.speedment.common.json.JsonSyntaxException;
import com.speedment.common.json.internal.JsonDeserializer;
import com.speedment.common.json.internal.JsonSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public final class Json {
    public static boolean PRETTY = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toJson(Object object) throws IllegalArgumentException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Json.toJson(object, out);
            String string = new String(out.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException("Error in internal toString()-stream.", ex);
        }
    }

    public static void toJson(Object object, OutputStream out) throws IllegalArgumentException, IOException {
        new JsonSerializer(out, PRETTY).print(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object fromJson(String json) throws JsonSyntaxException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));){
            Object object = Json.fromJson(stream);
            return object;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object fromJson(InputStream in) throws IOException, JsonSyntaxException {
        try (JsonDeserializer parser = new JsonDeserializer(in);){
            Object object = parser.get();
            return object;
        }
    }

    private Json() {
    }
}

