/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.jvm_version.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class InternalJvmVersion {
    private final String specificationTitle = System.getProperty("java.vm.specification.name");
    private final String specificationVersion = System.getProperty("java.vm.specification.version");
    private final String specificationVendor = System.getProperty("java.vm.specification.vendor");
    private final String implementationTitle = System.getProperty("java.specification.name");
    private final String implementationVersion;
    private final String implementationVendor;
    private final int major = this.version("major", 1);
    private final int minor = this.version("minor", 2);
    private final int security = this.version("security", 3);

    public InternalJvmVersion() {
        this.implementationVersion = String.format("%d.%d.%d", this.major, this.minor, this.security);
        this.implementationVendor = System.getProperty("java.specification.vendor");
    }

    public String getSpecificationTitle() {
        return this.specificationTitle;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public String getSpecificationVendor() {
        return this.specificationVendor;
    }

    public String getImplementationTitle() {
        return this.implementationTitle;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getImplementationVendor() {
        return this.implementationVendor;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int security() {
        return this.security;
    }

    private int version(String java9Name, int java8Index) {
        try {
            Method method = Runtime.class.getDeclaredMethod("version", new Class[0]);
            if (method != null) {
                Object version = method.invoke((Object)Runtime.getRuntime(), new Object[0]);
                Class<?> clazz = Class.forName("java.lang.Runtime$Version");
                return (Integer)clazz.getDeclaredMethod(java9Name, new Class[0]).invoke(version, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException method) {
            // empty catch block
        }
        try {
            return Integer.parseInt(System.getProperty("java.runtime.version").split("([\\._-])")[java8Index]);
        }
        catch (Throwable t) {
            return 0;
        }
    }
}

