/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.logger.internal;

import com.speedment.common.logger.Level;
import com.speedment.common.logger.Logger;
import com.speedment.common.logger.LoggerEventListener;
import com.speedment.common.logger.LoggerFormatter;
import com.speedment.common.logger.internal.LoggerEventImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

abstract class AbstractLogger
implements Logger {
    private final String name;
    private Level level;
    private LoggerFormatter formatter;
    private final Set<LoggerEventListener> listeners;
    private static final Throwable NO_THROWABLE = null;

    AbstractLogger(String name, LoggerFormatter formatter) {
        this.name = Objects.requireNonNull(name);
        this.level = Level.defaultLevel();
        this.formatter = Objects.requireNonNull(formatter);
        this.listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    protected abstract void output(String var1);

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(Level level) {
        this.level = Objects.requireNonNull(level);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setFormatter(LoggerFormatter formatter) {
        this.formatter = Objects.requireNonNull(formatter);
    }

    @Override
    public LoggerFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void addListener(LoggerEventListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(LoggerEventListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.remove(listener);
    }

    @Override
    public void trace(String message) {
        this.log(Level.TRACE, NO_THROWABLE, message);
    }

    @Override
    public void trace(Throwable throwable) {
        this.log(Level.TRACE, throwable, throwable == NO_THROWABLE ? "" : throwable.getMessage());
    }

    @Override
    public void trace(String format, Object arg) {
        this.log(Level.TRACE, NO_THROWABLE, format, arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.log(Level.TRACE, NO_THROWABLE, format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2, Object arg3) {
        this.log(Level.TRACE, NO_THROWABLE, format, arg1, arg2, arg3);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(Level.TRACE, NO_THROWABLE, format, arg1, arg2, arg3, args);
    }

    @Override
    public void trace(Throwable throwable, String message) {
        this.log(Level.TRACE, throwable, message);
    }

    @Override
    public void trace(Throwable throwable, String format, Object arg) {
        this.log(Level.TRACE, throwable, format, arg);
    }

    @Override
    public void trace(Throwable throwable, String format, Object arg1, Object arg2) {
        this.log(Level.TRACE, throwable, format, arg1, arg2);
    }

    @Override
    public void trace(Throwable throwable, String format, Object arg1, Object arg2, Object arg3) {
        this.log(Level.TRACE, throwable, format, arg1, arg2, arg3);
    }

    @Override
    public void trace(Throwable throwable, String format, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(Level.TRACE, throwable, format, arg1, arg2, arg3, args);
    }

    @Override
    public void debug(String message) {
        this.log(Level.DEBUG, NO_THROWABLE, message);
    }

    @Override
    public void debug(Throwable throwable) {
        this.log(Level.DEBUG, throwable, throwable == NO_THROWABLE ? "" : throwable.getMessage());
    }

    @Override
    public void debug(String format, Object arg) {
        this.log(Level.DEBUG, NO_THROWABLE, format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.log(Level.DEBUG, NO_THROWABLE, format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2, Object arg3) {
        this.log(Level.DEBUG, NO_THROWABLE, format, arg1, arg2, arg3);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(Level.DEBUG, NO_THROWABLE, format, arg1, arg2, arg3, args);
    }

    @Override
    public void debug(Throwable throwable, String message) {
        this.log(Level.DEBUG, throwable, message);
    }

    @Override
    public void debug(Throwable throwable, String format, Object arg) {
        this.log(Level.DEBUG, throwable, format, arg);
    }

    @Override
    public void debug(Throwable throwable, String format, Object arg1, Object arg2) {
        this.log(Level.DEBUG, throwable, format, arg1, arg2);
    }

    @Override
    public void debug(Throwable throwable, String format, Object arg1, Object arg2, Object arg3) {
        this.log(Level.DEBUG, throwable, format, arg1, arg2, arg3);
    }

    @Override
    public void debug(Throwable throwable, String format, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(Level.DEBUG, throwable, format, arg1, arg2, arg3, args);
    }

    @Override
    public void info(String message) {
        this.log(Level.INFO, NO_THROWABLE, message);
    }

    @Override
    public void info(Throwable throwable) {
        this.log(Level.INFO, throwable, throwable == NO_THROWABLE ? "" : throwable.getMessage());
    }

    @Override
    public void info(String format, Object arg) {
        this.log(Level.INFO, NO_THROWABLE, format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.log(Level.INFO, NO_THROWABLE, format, arg1, arg2);
    }

    @Override
    public void info(String format, Object arg1, Object arg2, Object arg3) {
        this.log(Level.INFO, NO_THROWABLE, format, arg1, arg2, arg3);
    }

    @Override
    public void info(String format, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(Level.INFO, NO_THROWABLE, format, arg1, arg2, arg3, args);
    }

    @Override
    public void info(Throwable throwable, String message) {
        this.log(Level.INFO, throwable, message);
    }

    @Override
    public void info(Throwable throwable, String format, Object arg) {
        this.log(Level.INFO, throwable, format, arg);
    }

    @Override
    public void info(Throwable throwable, String format, Object arg1, Object arg2) {
        this.log(Level.INFO, throwable, format, arg1, arg2);
    }

    @Override
    public void info(Throwable throwable, String format, Object arg1, Object arg2, Object arg3) {
        this.log(Level.INFO, throwable, format, arg1, arg2, arg3);
    }

    @Override
    public void info(Throwable throwable, String format, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(Level.INFO, throwable, format, arg1, arg2, arg3, args);
    }

    @Override
    public void warn(String message) {
        this.log(Level.WARN, NO_THROWABLE, message);
    }

    @Override
    public void warn(Throwable throwable) {
        this.log(Level.WARN, throwable, throwable == NO_THROWABLE ? "" : throwable.getMessage());
    }

    @Override
    public void warn(String format, Object arg) {
        this.log(Level.WARN, NO_THROWABLE, format, arg);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.log(Level.WARN, NO_THROWABLE, format, arg1, arg2);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2, Object arg3) {
        this.log(Level.WARN, NO_THROWABLE, format, arg1, arg2, arg3);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(Level.WARN, NO_THROWABLE, format, arg1, arg2, arg3, args);
    }

    @Override
    public void warn(Throwable throwable, String message) {
        this.log(Level.WARN, throwable, message);
    }

    @Override
    public void warn(Throwable throwable, String format, Object arg) {
        this.log(Level.WARN, throwable, format, arg);
    }

    @Override
    public void warn(Throwable throwable, String format, Object arg1, Object arg2) {
        this.log(Level.WARN, throwable, format, arg1, arg2);
    }

    @Override
    public void warn(Throwable throwable, String format, Object arg1, Object arg2, Object arg3) {
        this.log(Level.WARN, throwable, format, arg1, arg2, arg3);
    }

    @Override
    public void warn(Throwable throwable, String format, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(Level.WARN, throwable, format, arg1, arg2, arg3, args);
    }

    @Override
    public void error(String message) {
        this.log(Level.ERROR, NO_THROWABLE, message);
    }

    @Override
    public void error(Throwable throwable) {
        this.log(Level.ERROR, throwable, throwable == NO_THROWABLE ? "" : throwable.getMessage());
    }

    @Override
    public void error(String format, Object arg) {
        this.log(Level.ERROR, NO_THROWABLE, format, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.log(Level.ERROR, NO_THROWABLE, format, arg1, arg2);
    }

    @Override
    public void error(String format, Object arg1, Object arg2, Object arg3) {
        this.log(Level.ERROR, NO_THROWABLE, format, arg1, arg2, arg3);
    }

    @Override
    public void error(String format, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(Level.ERROR, NO_THROWABLE, format, arg1, arg2, arg3, args);
    }

    @Override
    public void error(Throwable throwable, String message) {
        this.log(Level.ERROR, throwable, message);
    }

    @Override
    public void error(Throwable throwable, String format, Object arg) {
        this.log(Level.ERROR, throwable, format, arg);
    }

    @Override
    public void error(Throwable throwable, String format, Object arg1, Object arg2) {
        this.log(Level.ERROR, throwable, format, arg1, arg2);
    }

    @Override
    public void error(Throwable throwable, String format, Object arg1, Object arg2, Object arg3) {
        this.log(Level.ERROR, throwable, format, arg1, arg2, arg3);
    }

    @Override
    public void error(Throwable throwable, String format, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(Level.ERROR, throwable, format, arg1, arg2, arg3, args);
    }

    @Override
    public void fatal(String message) {
        this.log(Level.FATAL, NO_THROWABLE, message);
    }

    @Override
    public void fatal(Throwable throwable) {
        this.log(Level.FATAL, throwable, throwable == NO_THROWABLE ? "" : throwable.getMessage());
    }

    @Override
    public void fatal(String format, Object arg) {
        this.log(Level.FATAL, NO_THROWABLE, format, arg);
    }

    @Override
    public void fatal(String format, Object arg1, Object arg2) {
        this.log(Level.FATAL, NO_THROWABLE, format, arg1, arg2);
    }

    @Override
    public void fatal(String format, Object arg1, Object arg2, Object arg3) {
        this.log(Level.FATAL, NO_THROWABLE, format, arg1, arg2, arg3);
    }

    @Override
    public void fatal(String format, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(Level.FATAL, NO_THROWABLE, format, arg1, arg2, arg3, args);
    }

    @Override
    public void fatal(Throwable throwable, String message) {
        this.log(Level.FATAL, throwable, message);
    }

    @Override
    public void fatal(Throwable throwable, String format, Object arg1, Object arg2) {
        this.log(Level.FATAL, throwable, format, arg1, arg2);
    }

    @Override
    public void fatal(Throwable throwable, String format, Object arg) {
        this.log(Level.FATAL, throwable, format, arg);
    }

    @Override
    public void fatal(Throwable throwable, String format, Object arg1, Object arg2, Object arg3) {
        this.log(Level.FATAL, throwable, format, arg1, arg2, arg3);
    }

    @Override
    public void fatal(Throwable throwable, String format, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(Level.FATAL, throwable, format, arg1, arg2, arg3, args);
    }

    protected void log(Level level, Throwable throwable, String message) {
        this.log(level, throwable, () -> message);
    }

    protected void log(Level level, Throwable throwable, String message, Object arg) {
        this.log(level, throwable, () -> String.format(message, arg));
    }

    protected void log(Level level, Throwable throwable, String message, Object arg1, Object arg2) {
        this.log(level, throwable, () -> String.format(message, arg1, arg2));
    }

    protected void log(Level level, Throwable throwable, String message, Object arg1, Object arg2, Object arg3) {
        this.log(level, throwable, () -> String.format(message, arg1, arg2, arg3));
    }

    protected void log(Level level, Throwable throwable, String message, Object arg1, Object arg2, Object arg3, Object ... args) {
        this.log(level, throwable, () -> {
            Object[] params = new Object[args.length + 3];
            params[0] = arg1;
            params[1] = arg2;
            params[2] = arg3;
            System.arraycopy(args, 0, params, 3, args.length);
            return String.format(message, params);
        });
    }

    protected void log(Level msgLevel, Throwable throwable, Supplier<String> supplier) {
        if (msgLevel.isEqualOrHigherThan(this.level)) {
            String logMsg = supplier.get();
            String outputMessage = this.fixMessage(msgLevel, logMsg, throwable);
            this.output(outputMessage);
            if (!this.listeners.isEmpty()) {
                LoggerEventImpl loggerEvent = new LoggerEventImpl(msgLevel, this.name, outputMessage);
                this.listeners.forEach(l -> l.accept(loggerEvent));
            }
        }
    }

    private String fixMessage(Level level, String msg, Throwable throwable) {
        StringBuilder sb = new StringBuilder(this.formatter.apply(level, this.name, msg));
        if (NO_THROWABLE != throwable) {
            StringWriter writer = new StringWriter();
            PrintWriter pipe = new PrintWriter(writer);
            throwable.printStackTrace(pipe);
            sb.append("\n").append(writer.toString());
        }
        return sb.toString();
    }
}

